
#include <stdbool.h>
#include <stdlib.h>
#include <stdio.h>

#include "invoke.h"

struct machine_context_t {
	void *SP;
	void *FP;
	void *PC;
};

extern void coInvokeStub( void );

// magically invoke the "main" of the most derived class
// Called from the kernel when starting a coroutine or task so must switch back to user mode.
void __invokeCoroutine__F_P9scoVtablePv__1(struct coVtable *vtable, void* vthis)
{
      printf("Invoke : Received %p (v %p)\n", vthis, vtable);

      struct coroutine* cor = vtable->this_coroutine(vthis);

      cor->state = Active;

      vtable->main(vthis);
}

void __startCoroutine__A0_1_0___this_coroutine__PFP10scoroutine_Pd0___co_main__PF_Pd0___vtable__PFP9scoVtable_Pd0__F_Pd0PF_P9scoVtablePv___1(
      struct coroutine *(*this_coroutine)(void * ), 
      void (*co_main)(void *), 
      struct coVtable *(*get_vtable)(void *), 
      void *vthis, 
      void (*invoke)(struct coVtable *, void *)
) {

      #if ! defined( __x86_64__ )
            #error Only __x86_64__ is supported for threads in cfa
      #endif

      #if defined( __U_SWAPCONTEXT__ )
            #error __U_SWAPCONTEXT__ should not be defined for __x86_64__
      #endif

      struct coVtable * vtable = get_vtable( vthis );
      struct coroutine* this = this_coroutine( vthis );
      struct coStack_t* stack = &this->stack;

      struct FakeStack {
            void *fixedRegisters[5];			// fixed registers rbx, r12, r13, r14, r15
            void *rturn;					// where to go on return from uSwitch
            void *dummyReturn;				// NULL return address to provide proper alignment
      }; // FakeStack

      ((struct machine_context_t *)stack->context)->SP = (char *)stack->base - sizeof( struct FakeStack );
      ((struct machine_context_t *)stack->context)->FP = NULL;		// terminate stack with NULL fp

      fprintf(stderr, "StartCoroutine : Passing in %p (v %p) to %p\n", vthis, vtable, invoke);

      ((struct FakeStack *)(((struct machine_context_t *)stack->context)->SP))->dummyReturn = NULL;
      ((struct FakeStack *)(((struct machine_context_t *)stack->context)->SP))->rturn = coInvokeStub;
      ((struct FakeStack *)(((struct machine_context_t *)stack->context)->SP))->fixedRegisters[0] = vtable;
      ((struct FakeStack *)(((struct machine_context_t *)stack->context)->SP))->fixedRegisters[1] = vthis;
      ((struct FakeStack *)(((struct machine_context_t *)stack->context)->SP))->fixedRegisters[2] = invoke;
}