//
// Cforall Version 1.0.0 Copyright (C) 2017 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Debug.h --
//
// Author           : Rob Schluntz
// Created On       : Fri Sep 1 11:09:14 2017
// Last Modified By : Rob Schluntz
// Last Modified On : Fri Sep 1 11:09:36 2017
// Update Count     : 2
//

#pragma once

#include <string>
#include <list>
#include <iostream>

#include "CodeGen/Generate.h"
#include "Parser/LinkageSpec.h"
#include "SynTree/Declaration.h"

/// debug codegen a translation unit
static inline void debugCodeGen( const std::list< Declaration * > & translationUnit, const std::string & label ) {
	std::list< Declaration * > decls;

	filter( translationUnit.begin(), translationUnit.end(), back_inserter( decls ), []( Declaration * decl ) {
		return ! LinkageSpec::isBuiltin( decl->get_linkage() );
	});

	std::cerr << "======" << label << "======" << std::endl;
	CodeGen::generate( decls, std::cerr, false, true );
} // dump

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
