//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// min.c -- 
//
// Author           : Richard C. Bilson
// Created On       : Wed May 27 17:56:53 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon Jan  4 11:40:51 2016
// Update Count     : 26
//

#include "fstream.h"

forall( type T | { int ?<?( T, T ); } )
T min( const T t1, const T t2 ) {
	return t1 < t2 ? t1 : t2;
} // min

int main( void ) {
	ofstream *sout = ofstream_stdout();
	// char does not have less than.
	int ?<?( char op1, char op2 ) { return (int)op1 < (int)op2; }

	sout | "char\t\t\t"					| 'z' | ' ' | 'a' | "\tmin " | min( 'z', 'a' ) | endl;
	sout | "signed int\t\t"				| 4 | ' ' | 3 | "\tmin " | min( 4, 3 ) | endl;
	sout | "unsigned int\t\t"			| 4u | ' ' | 3u | "\tmin " | min( 4u, 3u ) | endl;
	sout | "signed long int\t\t" 		| 4l | ' ' | 3l | "\tmin " | min( 4l, 3l ) | endl;
	sout | "unsigned long int\t" 		| 4ul | ' ' | 3ul | "\tmin " | min( 4ul, 3ul ) | endl;
	sout | "signed long long int\t"		| 4ll | ' ' | 3ll | "\tmin " | min( 4ll, 3ll ) | endl;
	sout | "unsigned long long int\t"	| 4ull | ' ' | 3ull | "\tmin " | min( 4ull, 3ull ) | endl;
	sout | "float\t\t\t" 				| 4.0f | ' ' | 3.1f | "\tmin " | min( 4.0f, 3.1f ) | endl;
	sout | "double\t\t\t"				| 4.0 | ' ' | 3.1 | "\tmin " | min( 4.0, 3.1 ) | endl;
	sout | "long double\t\t"			| 4.0l | ' ' | 3.1l | "\tmin " | min( 4.0l, 3.1l ) | endl;
} // main

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa min.c fstream.o iostream.o iterator.o" //
// End: //
