//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// twice.c -- 
//
// Author           : Richard C. Bilson
// Created On       : Wed May 27 17:56:53 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon Jan  4 11:32:04 2016
// Update Count     : 10
//

#include "fstream.h"

forall( type T | { T ?+?( T, T ); T ?++( T * ); [T] ?+=?( T *, T ); } )
T twice( const T t ) {
	return t + t;
}

int main( void ) {
	// char does not have addition
	char ?+?( char op1, char op2 ) { return (int)op1 + op2; } // cast forces integer addition or recursion
	char ++?( char *op ) { *op += 1; return *op; }
	char ?++( char *op ) { char temp = *op; *op += 1; return temp; }

	ofstream *sout = ofstream_stdout();
	sout | twice( 'a' ) | ' ' | twice( 1 ) | ' ' | twice( 3.2 ) | endl;
}

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa twice.c fstream.o iostream.o iterator.o" //
// End: //
