//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// iostream.h -- 
//
// Author           : Richard C. Bilson
// Created On       : Wed May 27 17:56:53 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon Jan  4 09:02:11 2016
// Update Count     : 20
//

#ifndef IOSTREAM_H
#define IOSTREAM_H

#include "iterator.h"

typedef unsigned long streamsize_type;

context ostream( dtype ostype ) {
	ostype *write( ostype *, const char *, streamsize_type );
	int fail( ostype * );
};

context writeable( type T ) {
	forall( dtype ostype | ostream( ostype ) ) ostype * ?|?( ostype *, T );
};

// implement writable for some intrinsic types

forall( dtype ostype | ostream( ostype ) ) ostype * ?|?( ostype *, char );
forall( dtype ostype | ostream( ostype ) ) ostype * ?|?( ostype *, int );
forall( dtype ostype | ostream( ostype ) ) ostype * ?|?( ostype *, unsigned int );
forall( dtype ostype | ostream( ostype ) ) ostype * ?|?( ostype *, long int );
forall( dtype ostype | ostream( ostype ) ) ostype * ?|?( ostype *, long long int );
forall( dtype ostype | ostream( ostype ) ) ostype * ?|?( ostype *, unsigned long int );
forall( dtype ostype | ostream( ostype ) ) ostype * ?|?( ostype *, unsigned long long int );
forall( dtype ostype | ostream( ostype ) ) ostype * ?|?( ostype *, double );
forall( dtype ostype | ostream( ostype ) ) ostype * ?|?( ostype *, long double );
forall( dtype ostype | ostream( ostype ) ) ostype * ?|?( ostype *, const char * );
forall( dtype ostype | ostream( ostype ) ) ostype * ?|?( ostype *, const void * );

forall( dtype ostype, dtype retostype | ostream( ostype ) | ostream( retostype ) ) retostype * ?|?( ostype *os, retostype * (* manip)(ostype*) );
forall( dtype ostype | ostream( ostype ) ) ostype * endl( ostype * );

// writes the range [begin, end) to the given stream
forall( type elt_type | writeable( elt_type ),
		type iterator_type | iterator( iterator_type, elt_type ),
		dtype os_type | ostream( os_type ) )
void write( iterator_type begin, iterator_type end, os_type *os );

forall( type elt_type | writeable( elt_type ),
		type iterator_type | iterator( iterator_type, elt_type ),
		dtype os_type | ostream( os_type ) )
void write_reverse( iterator_type begin, iterator_type end, os_type *os );

//******************************************************************************

context istream( dtype istype ) {
	istype *read( istype *, char *, streamsize_type );
	istype *unread( istype *, char );
	int fail( istype * );
	int eof( istype * );
};

context readable( type T ) {
	forall( dtype istype | istream( istype ) ) istype * ?|?( istype *, T );
};

forall( dtype istype | istream( istype ) )
istype * ?|?( istype *, char * );

forall( dtype istype | istream( istype ) )
istype * ?|?( istype *, int * );

#endif // IOSTREAM_H

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa iostream.c" //
// End: //
