// #define BFX_INTRUSION(S)                         inline dlink(S);
// #define BFX_EXTRUSION_DECL(S)
// #define BFX_EXTRUSION_FOLLOWUP(S)                P9_EMBEDDED( S, dlink(S) )
// #define BFX_LIST_HEAD_T(S)                       dlist(S)
// #define BFX_LISTED_ELEM_T(S)                     S*

// #define BFX_INSERT_FIRST(S, lst, item)           (insert_first (lst, item), (S*)&(item))
// #define BFX_INSERT_LAST(S, lst, item)            (insert_last  (lst, item), (S*)&(item))
// #define BFX_INSERT_BEFORE(S, lst, item, refIter) (insert_before(*refIter, item), (S*)&(item))
// #define BFX_INSERT_AFTER(S, lst, item, refIter)  (insert_after (*refIter, item), (S*)&(item))
// #define BFX_REMOVE_FIRST(S, lst)                 pop_front(lst)
// #define BFX_REMOVE_LAST(S, lst)                  pop_back(lst)
// #define BFX_REMOVE_HERE(S, lst, refIter)         remove(*refIter)
// #define BFX_INIT(S, lst)

// #define BFX_GET_AFTER(S, lst, iter)              (&(*iter)`next)
// #define BFX_GET_BEFORE(S, lst, iter)             (&(*iter)`prev)
// #define BFX_IS_VALID_POS(S, lst, iter)           ((iter)!=NULL)
// #define BFX_DEREF_POS(S, lst, iter)              (iter)

#define BFX_INTRUSION(S)                         inline dlink(S);
#define BFX_EXTRUSION_DECL(S)
#define BFX_EXTRUSION_FOLLOWUP(S)                P9_EMBEDDED( S, dlink(S) )
#define BFX_LIST_HEAD_T(S)                       dlist(S)
#define BFX_LISTED_ELEM_T(S)                     S*

#define BFX_INSERT_FIRST(S, lst, item)           (insert_first (lst, item), (S*)&(item))
#define BFX_INSERT_LAST(S, lst, item)            (insert_last  (lst, item), (S*)&(item))
#define BFX_INSERT_BEFORE(S, lst, item, refIter) (insert_before(*refIter, item), (S*)&(item))
#define BFX_INSERT_AFTER(S, lst, item, refIter)  (insert_after (*refIter, item), (S*)&(item))
#define BFX_REMOVE_FIRST(S, lst)                 remove_first(lst)
#define BFX_REMOVE_LAST(S, lst)                  remove_last(lst)
#define BFX_REMOVE_HERE(S, lst, refIter)         remove(*refIter)
#define BFX_INIT(S, lst)

#define BFX_GET_AFTER(S, lst, iter)              ( & prev( * (iter) ) )
#define BFX_GET_BEFORE(S, lst, iter)             ( & next( * (iter) ) )
#define BFX_IS_VALID_POS(S, lst, iter)           ((iter)!=NULL)
#define BFX_DEREF_POS(S, lst, iter)              (iter)
