#!/usr/bin/python3

import argparse, os, sys, re

def dir_path(string):
    if os.path.isdir(string):
        return string
    else:
        raise NotADirectoryError(string)

parser = argparse.ArgumentParser()
parser.add_argument('--path', type=dir_path, default=".cfadata", help= 'paste path to biog.txt file')

try :
	args = parser.parse_args()
except NotADirectoryError:
	print("Must use option --path to existing directory or have .cfadata in current directory", file=sys.stderr)
	sys.exit(1)

root, _, filenames = next(os.walk(args.path))

merged = []
counters = {}

#open the files
for filename in filenames:
	try:
		m = re.search('[A-z]+0x([0-9a-f]+)\.data', filename)
		me = m.group(1)
		counters[me] = 0
		with open(os.path.join(root, filename), 'r') as file:
			for line in file:
				data = [int(x.strip()) for x in line.split(',')]
				data = [me, *data]
				merged.append(data)

	except:
		pass


# Sort by timestamp (the second element)
# take second element for sort
def takeSecond(elem):
    return elem[1]

merged.sort(key=takeSecond)

# for m in merged:
# 	print(m)

single = []
curr = 0

# merge the data
for (me, time, value) in merged:
	# check now much this changes
	old = counters[me]
	change = value - old
	counters[me] = value

	# add change to the current
	curr = curr + change
	single.append( (time, curr) )

	pass

#print
for t, v in single:
	print([t, v])
