//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// quad.c -- 
//
// Author           : Richard C. Bilson
// Created On       : Wed May 27 17:56:53 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed May 27 18:26:36 2015
// Update Count     : 2
//

extern "C" {
#include <stdio.h>
}

forall( type T | { T ?*?( T, T ); } )
T square( T t ) {
	return t * t;
}

forall( type U | { U square( U ); } )
U quad( U u ) {
	return square( square( u ) );
}

int main() {
	int N = 2;
	printf( "result of quad of %d is %d\n", N, quad( N ) );
}

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa quad.c" //
// End: //
