//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// prolog.c -- 
//
// Author           : Richard C. Bilson
// Created On       : Wed May 27 17:56:53 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed May 27 18:25:52 2015
// Update Count     : 1
//

extern "C" { extern int printf( const char *fmt, ... ); }

void printResult( int x ) { printf( "int\n" ); }
void printResult( double x ) { printf( "double\n" ); }
void printResult( char * x ) { printf( "char*\n" ); }

void is_arithmetic( int x ) {}
void is_arithmetic( double x ) {}

void is_integer( int x ) {}

context ArithmeticType( type T ) {
	void is_arithmetic( T );
};

context IntegralType( type T | ArithmeticType( T ) ) {
	void is_integer( T );
};

forall( type T | IntegralType( T ) | { void printResult( T ); } )
void hornclause( T param ) {
	printResult( param );
}

int main() {
	int x;
	double x;
	char * x;
	hornclause( x );
}

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa prolog.c" //
// End: //
