//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// fstream.h -- 
//
// Author           : Richard C. Bilson
// Created On       : Wed May 27 17:56:53 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed May 27 18:13:08 2015
// Update Count     : 1
//

#ifndef __FSTREAM_H__
#define __FSTREAM_H__

#include "iostream.h"

typedef struct ofstream ofstream;

// implement context ostream
ofstream *write( ofstream *, const char *, streamsize_type );
int fail( ofstream * );

ofstream *ofstream_stdout();
ofstream *ofstream_stderr();
ofstream *ofstream_fromfile( const char *name );
void ofstream_close( ofstream *os );

typedef struct ifstream ifstream;

// implement context istream
ifstream *read( ifstream *, char *, streamsize_type );
ifstream *unread( ifstream *, char );
int fail( ifstream * );
int eof( ifstream * );

ifstream *ifstream_stdin();
ifstream *ifstream_fromfile( const char *name );

#endif // __FSTREAM_H__

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa fstream.c" //
// End: //
