#!/bin/bash

script="$(dirname "$0")/setup.sh.in"
if [ ! -f $script ]; then
	>&2 echo "Cannot find $script"
	exit 1
fi

if [ -f "setup.sh" ]; then
	>&2 echo "setup.sh already exists, would overwrite it"
	exit 1
fi

echo "#!/bin/bash" > setup.sh
echo "" >> setup.sh
chmod a+x setup.sh

echo "arch=\"$(uname -m)\"" >> setup.sh
echo "name=\"$(uname -n)\"" >> setup.sh
echo "" >> setup.sh
echo "# ---- copied from $script ----" >> setup.sh
echo "" >> setup.sh

cat $script >> setup.sh
