//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// BaseSyntaxNode.h --
//
// Author           : Thierry Delisle
// Created On       : Tue Feb 14 07:44:20 2017
// Last Modified By : Andrew Beach
// Last Modified On : Thr Aug 17 13:44:00
// Update Count     : 1
//

#pragma once

#include "Common/CodeLocation.h"
class Visitor;

class BaseSyntaxNode {
  public:
	CodeLocation location;

	virtual ~BaseSyntaxNode() {}

	virtual void accept( Visitor & v ) = 0;
  	virtual void print( std::ostream & os, int indent = 0 ) const = 0;
};

std::ostream & operator<<( std::ostream & out, const BaseSyntaxNode * node );

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
