//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// sum.c -- test resolvers ability to deal with many variables with the same name and to use the minimum number of casts
//    necessary to disambiguate overloaded variable names.
//
// Author           : Peter A. Buhr
// Created On       : Wed May 27 17:56:53 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Fri Jan 26 11:31:02 2018
// Update Count     : 271
//

#include <fstream>
#include <stdlib>

void ?{}( int & c, zero_t ) { c = 0; }

trait sumable( otype T ) {
	void ?{}( T &, zero_t );							// constructor from 0 literal
	T ?+?( T, T );										// assortment of additions
	T ?+=?( T &, T );
	T ++?( T & );
	T ?++( T & );
}; // sumable

forall( otype T | sumable( T ) )						// use trait
T sum( unsigned int size, T a[] ) {
	T total = 0;										// instantiate T from 0 by calling constructor
	for ( unsigned int i = 0; i < size; i += 1 )
		total += a[i];									// select appropriate +
	return total;
} // sum

// Not in prelude.
unsigned char ?+?( unsigned char t1, unsigned char t2 ) { return (int)t1 + t2; } // cast forces integer addition, otherwise recursion
unsigned char ?+=?( unsigned char & t1, unsigned char t2 ) { t1 = t1 + t2; return t1; }
unsigned char ++?( unsigned char & t ) { t += 1; return t; }
unsigned char ?++( unsigned char & t ) { unsigned char temp = t; t += 1; return temp; }

// Not in prelude.
void ?{}( unsigned char & c, zero_t ) { c = 0; }
void ?{}( float & f, zero_t ) { f = 0.0; }
void ?{}( double & d, zero_t ) { d = 0.0; }

int main( void ) {
	const int low = 5, High = 15, size = High - low;

	unsigned char s = 0, a[size], v = (char)low;
	for ( int i = 0; i < size; i += 1, v += 1 ) {
		s += v;
		a[i] = v;
	} // for
	sout | "sum from" | low | "to" | High | "is"
		 | sum( size, (unsigned char *)a ) | ", check" | (int)s | endl;

	int s = 0, a[size], v = low;
	for ( int i = 0; i < size; i += 1, v += 1 ) {
		s += (int)v;
		a[i] = (int)v;
	} // for
	sout | "sum from" | low | "to" | High | "is"
		 | sum( size, (int *)a ) | ", check" | (int)s | endl;

	float s = 0.0f, a[size], v = low / 10.0f;
	for ( int i = 0; i < size; i += 1, v += 0.1f ) {
		s += (float)v;
		a[i] = (float)v;
	} // for
	sout | "sum from" | low / 10.0f | "to" | High / 10.0f | "is"
		 | sum( size, (float *)a ) | ", check" | (float)s | endl;

	double s = 0.0, a[size], v = low / 10.0;
	for ( int i = 0; i < size; i += 1, v += 0.1 ) {
		s += (double)v;
		a[i] = (double)v;
	} // for
	sout | "sum from" | low / 10.0 | "to" | High / 10.0 | "is"
		 | sum( size, (double *)a ) | ", check" | (double)s | endl;

	struct S { int i, j; };
	void ?{}( S & s ) { s.[i, j] = 0; }
	void ?{}( S & s, int i, int j ) { s.[i,j] = [i, j]; }
	void ?{}( S & s, zero_t ) { s.[i,j] = 0; }
	void ?{}( S & s, one_t ) { s.[i,j] = 1; }
	S ?+?( S t1, S t2 ) { return (S){ t1.i + t2.i, t1.j + t2.j }; }
	S ?+=?( S & t1, S t2 ) { t1 = t1 + t2; return t1; }
	S ++?( S & t ) { t += (S){1}; return t; }
	S ?++( S & t ) { S temp = t; t += (S){1}; return temp; }
	ofstream & ?|?( ofstream & os, S v ) { return os | v.i | v.j; }

	S s = (S){0}, a[size], v = { low, low };
	for ( int i = 0; i < size; i += 1, v += (S){1} ) {
		s += (S)v;
		a[i] = (S)v;
	} // for
	sout | "sum from" | low | "to" | High | "is"
		 | sum( size, (S *)a ) | ", check" | (S)s | endl;

	forall( otype Impl | sumable( Impl ) )
	struct GS {
		Impl * x, * y;
	};
	GS(int) gs;
	gs.x = anew( size );								// create array storage for field
	s = 0; v = low;
	for ( int i = 0; i < size; i += 1, v += 1 ) {
		s += (int)v;
		gs.x[i] = (int)v;								// set filed array in generic type
	} // for
	sout | "sum from" | low | "to" | High | "is"
		 | sum( size, gs.x ) | ", check" | (int)s | endl; // add filed array in generic type
} // main

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa sum.c" //
// End: //
