struct WrappedInt {
  int x;
};

void ?{}(WrappedInt & this) {
  printf("constructing int\n");
  this.x = 0;
}

void ?{}(WrappedInt & this, WrappedInt other) {
  printf("copy constructing int: %d\n", other.x);
  this.x = other.x;
}

void ?{}(WrappedInt & this, int x) {
  printf("constructing int: %d\n", x);
  this.x = x;
}

void ^?{}(WrappedInt & this) {
  printf("destructing int: %d\n", this.x);
}

void ?=?(WrappedInt & this, int x) {
  printf("assigning int: %d %d\n", this.x, x);
  this.x = x;
}

struct A {
  WrappedInt x, y, z;
};

void ?{}(A & a) {
  // currently must define default ctor, since there's no "= default" syntax
}

void ?{}(A & a, int x) {
  printf("begin construct A\n");
  printf("construct a.x\n");
  (a.x){ x+999 };
  printf("assign a.y\n");
  a.y = 0; // not a constructor - default constructor will be inserted
  printf("end construct A\n");
} // z never constructed - will be automatically default constructed

void ?{}(A & this, A other) {
  printf("begin copy construct A\n");
  printf("copy construct this.x\n");
  (this.x){ other.x };
  printf("assign this.y\n");
  this.y = other.y; // not a constructor - copy constructor will be inserted
  printf("end copy construct A\n");
} // z never constructed - will be automatically copy constructed

A ?=?(A & this, A other) {
  printf("begin ?=? A\n");
  this.x = other.x;
  this.y = other.y;
  this.z = other.z;
  printf("end ?=? A\n");
  return this;
}

struct B {
  A a1, a2, a3;
};

void ?{}(B & b) {
  printf("begin construct B\n");
  printf("assign b.a2\n");
  b.a2 = (A) { 2 };
  printf("construct b.a1\n");
  (b.a1){ 1 };
#ifdef ERR1
  (b.a2){ b.a3 }; // error, b->a2 was used previously but is explicitly constructed
#endif
  printf("end construct B\n");
} // a2, a3 never constructed - will be automatically default constructed

void ^?{}(B & b) {
  b.a2 = (A) { 0 };
  ^(b.a1){};
} // a2, a3 never destructed - will be automatically destructed

int main() {
  printf("Before declaration of b1\n");
  B b1;
  printf("Before declaration of b2\n");
  B b2 = b1;
  printf("End of main\n");
}
