#include <stdio.h>
#include "cfa-pair.h"
#include "cfa-print.h"

forall(otype T, ttype Params | { void print(FILE*, T); void print(FILE*, Params); })
void print(FILE* out, T arg, Params rest) {
	print(out, arg);
	print(out, rest);
}

void print(FILE* out, const char* x) { fprintf(out, "%s", x); }

void print(FILE* out, _Bool x) { fprintf(out, "%s", x ? "true" : "false"); }

void print(FILE* out, char x) {
	if ( 0x20 <= x && x <= 0x7E ) { fprintf(out, "'%c'", x); }
	else { fprintf(out, "'\\%x'", x); }
}

void print(FILE* out, int x) { fprintf(out, "%d", x); }

forall(otype R, otype S | { void print(FILE*, R); void print(FILE*, S); })
void print(FILE* out, pair(R, S) x) {
	fprintf(out, "[");
	print(out, x.first);
	fprintf(out, ", ");
	print(out, x.second);
	fprintf(out, "]");
}
