#include <algorithm>
#include <fstream>
#include "bench.hpp"
#include "cpp-vstack.hpp"
#include "cpp-vprint.hpp"
#include "object.hpp"

int main(int argc, char** argv) {
	std::ofstream out{"/dev/null"};
	integer maxi{ 0 }, vali{ 42 };
	stack si, ti;
	
	REPEAT_TIMED( "push_int", N, si.push( vali ); )
	TIMED( "copy_int", ti = si; )
	TIMED( "clear_int", si.clear(); )
	REPEAT_TIMED( "pop_int", N, maxi = std::max( maxi, ti.pop()->as<integer>() ); /***/ )
	REPEAT_TIMED( "print_int", N/2, print( out, vali, c_string{":"}, vali, c_string{"\n"} ); )

	ptr<pair> maxp = make<pair>( make<boolean>(false), make<character>('\0') );
	pair valp{ make<boolean>(true), make<character>('a') };
	stack sp, tp;
	
	REPEAT_TIMED( "push_pair", N, sp.push( valp ); )
	TIMED( "copy_pair", tp = sp; )
	TIMED( "clear_pair", sp.clear(); )
	REPEAT_TIMED( "pop_pair", N, 
		ptr<pair> xp = as_ptr<pair>( tp.pop() ); /***/
		if ( *xp > *maxp ) { maxp = std::move(xp); } )
	REPEAT_TIMED( "print_pair", N/2, print( out, valp, c_string{":"}, valp, c_string{"\n"} ); )
}
