#pragma once
#include "object.hpp"

class stack {
	struct node {
		ptr<object> value;
		node* next;

		node( const object& v, node* n = nullptr );
	};
	node* head;

	void copy(const stack& o);
public:
	stack();
	stack(const stack& o);
	stack(stack&& o);
	~stack();
	stack& operator= (const stack& o);
	stack& operator= (stack&& o);

	void clear();
	bool empty() const;
	void push(const object& value);
	ptr<object> pop();
};
