#include <algorithm>
#include <fstream>
#include "bench.hpp"
#include "cpp-stack.hpp"
#include "cpp-pair.hpp"
#include "cpp-print.hpp"

int main(int argc, char** argv) {
	std::ofstream out{"/dev/null"};
	int maxi = 0, vali = 42;
	stack<int> si, ti;
	
	REPEAT_TIMED( "push_int", N, si.push( vali ); )
	TIMED( "copy_int", ti = si; )
	TIMED( "clear_int", si.clear(); )
	REPEAT_TIMED( "pop_int", N, maxi = std::max( maxi, ti.pop() ); )
	REPEAT_TIMED( "print_int", N/2, print( out, vali, ":", vali, "\n" ); )

	pair<bool, char> maxp = { false, '\0' }, valp = { true, 'a' };
	stack<pair<bool, char>> sp, tp;
	
	REPEAT_TIMED( "push_pair", N, sp.push( valp ); )
	TIMED( "copy_pair", tp = sp; )
	TIMED( "clear_pair", sp.clear(); )
	REPEAT_TIMED( "pop_pair", N, maxp = std::max( maxp, tp.pop() ); )
	REPEAT_TIMED( "print_pair", N/2, print( out, valp, ":", valp, "\n" ); )
}
