set terminal pslatex size 5.8, 2.4 color solid 9;
#set terminal postscript portrait enhanced size 7.5, 10. color solid 9.5;
#set terminal wxt size 950,1250

DIR=GRAPH

set macros
set output GRAPH."2.tex"
#set pointsize 2.0
set grid linetype 0
set xtics (4,8,16,32)
#set autoscale y
set logscale x

array titles[8];
titles[1] = "user sbrk"
titles[2] = "system sbrk"
titles[3] = "real sbrk"
titles[4] = "max memory sbrk"
titles[5] = "user mmap"
titles[6] = "system mmap"
titles[7] = "real mmap"
titles[8] = "max memory mmap"

set xrange [3:38]

set multiplot layout 2,4 rowsfirst margins 0.06,0.98,0.08,0.87 spacing 0.08,0.18

if ( strstrt( GRAPH, "prolog" ) != 0 ) {
	set key maxrows 1 at screen 0.99, screen 1.04 samplen 0.5 font "Helvetica,18"
} else {
	set key off
}

do for [x = 0:7] {
	set logscale y 10
	set yrange [*:*]
	unset ylabel
	if ( x == 3 || x == 7 ) {
		set title titles[x+1]
#		set logscale y 2
		unset logscale y
		set format y '%.0s'
		set yrange [2:*]
		set ylabel "megabytes" offset 1.0,0
	} else {
		if ( x == 0 || x == 4 ) {
			set ylabel "sec., log scale" offset 1.5,0
		}
		set format y '%g'
		if ( x == 1 || x == 5 ) {
			set title titles[x+1]
			set yrange [1:*]
		} else {
			set title titles[x+1]
		}
	}
	plot DIR."/testdata.res" \
		   i x*7   using 1:2 title columnheader(1) lt rgb "blue"	pt  2  ps 2 lw 1, \
		'' i x*7+1 using 1:2 title columnheader(1) lt rgb "dark-green"	pt  3  ps 2 lw 1, \
		'' i x*7+2 using 1:2 title columnheader(1) lt rgb "coral"	pt  14  ps 2 lw 4, \
		'' i x*7+3 using 1:2 title columnheader(1) lt rgb "black"	pt  16  ps 2 lw 2, \
		'' i x*7+4 using 1:2 title columnheader(1) lt rgb "red"		pt  8  ps 2 lw 2, \
		'' i x*7+5 using 1:2 title columnheader(1) lt rgb "dark-violet" pt  10  ps 2 lw 1, \
		'' i x*7+6 using 1:2 title columnheader(1) lt rgb "brown"	pt  4  ps 2 lw 1
}
unset multiplot

#test
