DIR=GRAPH
SCALE=100000000
set macros
set output GRAPH.".ownership.tex"
#set pointsize 2.0
set grid linetype 0
set xtics (2,4,8,16,32,64,128)
set yrange [5:1000]
set ytics (5,10,25,100,250,1000)
set format y "%4g"
set logscale x
set logscale y

if ( GRAPH eq "prolog" ) {
	set terminal pslatex size 1.85, 2.25 color solid 9;
	set ylabel sprintf( "Throughput, sec. $\\times$ %g, log scale", SCALE ) offset 1.2,0
	set key maxrows 1 at screen 3.28, screen 1.03 samplen 0.5 font "Helvetica,18"
	set title "ARM (a)"
} else {
	set terminal pslatex size 1.7, 2.25 color solid 9;
	set key off
	if ( GRAPH eq "swift" ) {
	set title "AMD (b)"
} else { if ( GRAPH eq "java" ) {
	set title "Intel (c)"
} else {
	print "unknown machine name"
	exit
}}}

plot DIR."/ownership.hexp" \
	   i 0 using 2:($4/SCALE) title columnheader(1) lt rgb "blue"	pt  2  ps 2 lw 1, \
	'' i 1 using 2:($4/SCALE) title columnheader(1) lt rgb "dark-green"	pt  3  ps 2 lw 1, \
	'' i 2 using 2:($4/SCALE) title columnheader(1) lt rgb "coral"	pt  14  ps 2 lw 4, \
	'' i 3 using 2:($4/SCALE) title columnheader(1) lt rgb "black"	pt  16  ps 2 lw 2, \
	'' i 4 using 2:($4/SCALE) title columnheader(1) lt rgb "red"	pt  8  ps 2 lw 2, \
	'' i 5 using 2:($4/SCALE) title columnheader(1) lt rgb "dark-violet" pt  10  ps 2 lw 1, \
	'' i 6 using 2:($4/SCALE) title columnheader(1) lt rgb "brown"	pt  4  ps 2 lw 1
