DIR=GRAPH

set terminal pslatex size 1.85, 2.25 color solid 9;
set ylabel "System time, sec." offset 1.5,0
#set terminal postscript portrait enhanced size 7.5, 10. color solid 9.5;
#set terminal wxt size 950,1250

set macros
set output GRAPH.".ownershipres.tex"
#set pointsize 2.0
set grid linetype 0
set xtics (2,4,8,16,32,64,128)
set yrange [0:1000]
set ytics 0,200,1000
set format y "%4g"
set logscale x
#set logscale y
#set key at screen 1.3, screen top - .01
set key off

if ( GRAPH eq "prolog" ) {
	set title "ARM"
} else { if ( GRAPH eq "swift" ) {
	set title "AMD (d)"
} else { if ( GRAPH eq "java" ) {
	set title "Intel"
} else {
	print "unknown machine name"
	exit
}}}

#set multiplot layout 1,2 rowsfirst margins 0.2,top,0.03,top spacing 0.24,0.08
	plot DIR."/ownership.hres" \
		   i 0 using 1:3 title columnheader(1) lt rgb "blue"	pt  2  ps 2 lw 1, \
		'' i 1 using 1:3 title columnheader(1) lt rgb "dark-green"	pt  3  ps 2 lw 1, \
		'' i 2 using 1:3 title columnheader(1) lt rgb "coral"	pt  14  ps 2 lw 4, \
		'' i 3 using 1:3 title columnheader(1) lt rgb "black"	pt  16  ps 2 lw 2, \
		'' i 4 using 1:3 title columnheader(1) lt rgb "red"	pt  8  ps 2 lw 2, \
		'' i 5 using 1:3 title columnheader(1) lt rgb "dark-violet" pt  10  ps 2 lw 1, \
		'' i 6 using 1:3 title columnheader(1) lt rgb "brown"	pt  4  ps 2 lw 1
