set terminal pslatex size 6.125, 7.6 color solid 9;
#set terminal postscript portrait enhanced size 7.5, 10. color solid 9.5;
#set terminal wxt size 950,1250

DIR=GRAPH

set macros
set output GRAPH.".tex"
#set pointsize 2.0
set grid linetype 0
set xtics (4,8,16,32)
set format y "%4g"
set logscale x
set logscale y

array titles[13];
titles[1] = "x = malloc( 0 ) / free( x )"
titles[2] = "free( NULL )"
titles[3] = "x = malloc( 42 ) / free( x )"
titles[4] = "x[0..100) = malloc( 42 ) / free( x[0..100 ) )"
titles[5] = "x[0..1000) = malloc( 42 ) / free( x[0..1000 ) )"
titles[6] = "x[0..100) = malloc( 42 ) / free( x(100..0] )"
titles[7] = "x[0..1000) = malloc( 42 ) / free( x(1000..0] )"
titles[8] = "x = malloc( [0..100) ) / free( x )"
titles[9] = "x[0..100) = malloc( [0..100) ) / free( x[0..100) )"
titles[10] = "x[0..1000) = malloc( [0..1000) ) / free( x[0..1000) )"
titles[11] = "x[0..100) = malloc( [0..100) ) / free( x(100..0] )"
titles[12] = "x[0..1000) = malloc( [0..1000) ) / free( x(1000..0] )"
titles[13] = "MMAP repeats experiments 3-7 with malloc( 1Mb )"

array yrange[17];
yrange[1] = 300
yrange[2] = 30
yrange[3] = 300
yrange[4] = 300
yrange[5] = 3000
yrange[6] = 300
yrange[7] = 3000
yrange[8] = 300
yrange[9] = 300
yrange[10] = 3000
yrange[11] = 300
yrange[12] = 3000
yrange[13] = 300
yrange[14] = 300
yrange[15] = 300
yrange[16] = 300
yrange[17] = 300

set xrange [3:38]

top=.992
set label "Allocators" at screen .46, screen top
set key at screen 0.57, screen top - .01
set label "Experiment \\#" at screen .65, screen top
do for [x = 0:11] {
   set label sprintf( "%2d. %s", x+1, titles[x+1] ) at screen .58, screen top - .02 - x * 0.016
}
set label titles[13] at screen .59, screen top - .02 - 12 * 0.016 - 0.001
set label "SBRK" at screen 0, screen 1.01
set label "MMAP" at screen 0, screen 0.245

set multiplot layout 4,5 rowsfirst margins 0.08,0.96,0.03,0.97 spacing 0.06,0.08
do for [x = 0:1] {
	if ( x == 0 ) {
		set ylabel "Elapse Time, sec., log scale" offset 1.5,0
		set yrange [20:yrange[x+1]]
		set ytics (20,50,100,yrange[x+1])
	} else {
		unset ylabel
		set yrange [10:yrange[x+1]]
		set ytics (10,15,20,yrange[x+1])
	}
	#set title titles[x+1]
	set title "Experiment ".(x+1)
	plot DIR."/testdata.exp" \
		   i x*7   using 1:2:3 title columnheader(1) with errorbars lt rgb "blue"	pt  2  ps 2 lw 1, \
		'' i x*7+1 using 1:2:3 title columnheader(1) with errorbars lt rgb "dark-green"	pt  3  ps 2 lw 1, \
		'' i x*7+2 using 1:2:3 title columnheader(1) with errorbars lt rgb "coral"	pt  14  ps 2 lw 4, \
		'' i x*7+3 using 1:2:3 title columnheader(1) with errorbars lt rgb "black"	pt  16  ps 2 lw 2, \
		'' i x*7+4 using 1:2:3 title columnheader(1) with errorbars lt rgb "red"	pt  8  ps 2 lw 2, \
		'' i x*7+5 using 1:2:3 title columnheader(1) with errorbars lt rgb "dark-violet" pt  10  ps 2 lw 1, \
		'' i x*7+6 using 1:2:3 title columnheader(1) with errorbars lt rgb "brown"	pt  4  ps 2 lw 1
}
set multiplot next
set multiplot next
set multiplot next
do for [x = 2:16] {
	if ( x == 2 || x == 7  || x == 12 ) {
		set ylabel "Elapse Time, sec., log scale" offset 1.5,0
	} else {
		unset ylabel
	}
	#set title titles[x+1]
	if ( x < 12 ) {
		set title "Experiment ".(x+1)
		set yrange [20:yrange[x+1]]
		set ytics (20,50,100,300,1000,yrange[x+1])
	} else {
		set title "Experiment ".(x+1-10)
		set yrange [.1:yrange[x+1]]
		set ytics (.1,.5,10,25,100,yrange[x+1])
	}
	plot DIR."/testdata.exp" \
		   i x*7   using 1:2:3 title columnheader(1) with errorbars lt rgb "blue"	pt  2  ps 2 lw 1, \
		'' i x*7+1 using 1:2:3 title columnheader(1) with errorbars lt rgb "dark-green" pt  3  ps 2 lw 1, \
		'' i x*7+2 using 1:2:3 title columnheader(1) with errorbars lt rgb "coral"	pt  14  ps 2 lw 4, \
		'' i x*7+3 using 1:2:3 title columnheader(1) with errorbars lt rgb "black"	pt  16  ps 2 lw 2, \
		'' i x*7+4 using 1:2:3 title columnheader(1) with errorbars lt rgb "red	"	pt  8  ps 2 lw 2, \
		'' i x*7+5 using 1:2:3 title columnheader(1) with errorbars lt rgb "dark-violet" pt  10  ps 2 lw 1, \
		'' i x*7+6 using 1:2:3 title columnheader(1) with errorbars lt rgb "brown"	pt  4  ps 2 lw 1
}
unset multiplot

#test
