DIR=GRAPH
SCALE=100000000
set macros
set output GRAPH.".cacheL.tex"
#set pointsize 2.0
set grid linetype 0
set xtics (4,8,16,32)
set logscale x
set yrange [2:*]
set ytics 2
#set format y "%3g"
#set logscale y

if ( GRAPH eq "prolog" ) {
	set terminal pslatex size 1.15, 2.125 color solid 9;
#	set ylabel sprintf( "Elapse Time, sec.", SCALE ) offset 1,0
#	set key maxrows 1 at screen 4.5, screen 1.03 samplen 1 font "Helvetica,18"
	set key off
	set title "ARM"
} else {
	set terminal pslatex size 1.15, 2.125 color solid 9;
	set key off
	if ( GRAPH eq "swift" ) {
	set title "AMD"
} else { if ( GRAPH eq "java" ) {
	set title "Intel"
} else {
	print "unknown machine name"
	exit
}}}

plot DIR."/cacheL" \
	   i 0 using 1:4 title columnheader(1) lt rgb "blue"	pt  2  ps 2 lw 1, \
	'' i 1 using 1:4 title columnheader(1) lt rgb "dark-green"	pt  3  ps 2 lw 1, \
	'' i 2 using 1:4 title columnheader(1) lt rgb "coral"	pt  14  ps 2 lw 4, \
	'' i 3 using 1:4 title columnheader(1) lt rgb "black"	pt  16  ps 2 lw 2, \
	'' i 4 using 1:4 title columnheader(1) lt rgb "red"	pt  8  ps 2 lw 2, \
	'' i 5 using 1:4 title columnheader(1) lt rgb "dark-violet" pt  10  ps 2 lw 1, \
	'' i 6 using 1:4 title columnheader(1) lt rgb "brown"	pt  4  ps 2 lw 1
