//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// LabelFixer.h -- 
//
// Author           : Rodolfo G. Esteves
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon Jun 29 17:24:39 2015
// Update Count     : 29
//

#ifndef LABEL_FIXER_H
#define LABEL_FIXER_H

#include "utility.h"
#include "SynTree/SynTree.h"
#include "SynTree/Visitor.h"
#include "LabelGenerator.h"

#include <map>

namespace ControlStruct {
	/// normalizes label definitions and generates multi-level exit labels
	class LabelFixer : public Visitor {
		typedef Visitor Parent;
	  public:
		LabelFixer( LabelGenerator *gen = 0 );

		std::map < Label, Statement * > *resolveJumps() throw ( SemanticError );

		// Declarations
		virtual void visit( FunctionDecl *functionDecl );

		// Statements
		void visit( Statement *stmt );

		virtual void visit( CompoundStmt *stmt ) { visit( (Statement *)stmt ); return Parent::visit( stmt ); }
		virtual void visit( NullStmt *stmt ) { visit( (Statement *)stmt ); return Parent::visit( stmt ); }
		virtual void visit( ExprStmt *stmt ) { visit( (Statement *)stmt ); return Parent::visit( stmt ); }
		virtual void visit( IfStmt *stmt ) { visit( (Statement *)stmt ); return Parent::visit( stmt ); }
		virtual void visit( WhileStmt *stmt ) { visit( (Statement *)stmt ); return Parent::visit( stmt ); }
		virtual void visit( ForStmt *stmt ) { visit( (Statement *)stmt ); return Parent::visit( stmt ); }
		virtual void visit( SwitchStmt *stmt ) { visit( (Statement *)stmt ); return Parent::visit( stmt ); }
		virtual void visit( ChooseStmt *stmt ) { visit( (Statement *)stmt ); return Parent::visit( stmt ); }
		virtual void visit( FallthruStmt *stmt ) { visit( (Statement *)stmt ); return Parent::visit( stmt ); }
		virtual void visit( CaseStmt *stmt ) { visit( (Statement *)stmt ); return Parent::visit( stmt ); }
		virtual void visit( ReturnStmt *stmt ) { visit( (Statement *)stmt ); return Parent::visit( stmt ); }
		virtual void visit( TryStmt *stmt ) { visit( (Statement *)stmt ); return Parent::visit( stmt ); }
		virtual void visit( CatchStmt *stmt ) { visit( (Statement *)stmt ); return Parent::visit( stmt ); }
		virtual void visit( DeclStmt *stmt ) { visit( (Statement *)stmt ); return Parent::visit( stmt ); }
		virtual void visit( BranchStmt *branchStmt );
		virtual void visit( UntypedExpr *untyped );

		Label setLabelsDef( std::list< Label > &, Statement *definition );
		template< typename UsageNode >
		void setLabelsUsg( Label, UsageNode *usage = 0 );

	  private:
		class Entry {
			public:
			union UsageLoc {
				Statement * stmt;
				Expression * expr;

				void accept( Visitor &visitor );
			};

			Entry( Statement *to ) : definition( to ) {}
			Entry( Statement *to, Statement *from );
			Entry( Statement *to, Expression *from );
			bool used() { return ( usage.empty() ); }
			bool defined() { return ( definition != 0 ); }
			bool insideLoop();

			Label get_label() const { return label; }
			void set_label( Label lab ) { label = lab; }

			Statement *get_definition() const { return definition; }
			void set_definition( Statement *def ) { definition = def; }

			std::list< UsageLoc > &get_uses() { return usage; }
			void add_use( Statement *use ) {
				UsageLoc loc;
				loc.stmt = use;
				usage.push_back( loc ); 
			}
			void add_use( Expression *use ) {
				UsageLoc loc;
				loc.expr = use;
				usage.push_back( loc ); 				
			}

			void add_uses ( Entry &other ) { usage.insert( usage.end(), other.usage.begin(), other.usage.end() ); }
		  private:
			Label label;  
			Statement *definition;
			std::list<UsageLoc> usage;
		};
	          
		std::map < Label, Entry *> labelTable;
		LabelGenerator *generator;
		Statement * currentStatement;
	};
} // namespace ControlStruct

#endif // LABEL_FIXER_H

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
