//
// Cforall Version 1.0.0 Copyright (C) 2018 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// fallthrough.c --
//
// Author           : Rob Schluntz
// Created On       : Wed Mar 14 10:06:25 2018
// Last Modified By : Rob Schluntz
// Last Modified On : Wed Mar 14 10:32:12 2018
// Update Count     : 2
//

void test(int choice) {
	choose ( choice ) {
		case 1:
			printf("case 1\n");
			fallthru;
		case 2:
			printf("case 2\n");
			fallthru;
			printf("did not fallthru\n");
			if ( 7 ) fallthru common2;
			fallthru common1;
		case 3:
			printf("case 3\n");
			fallthru default;
			fallthru common1;
		common1:
			printf("common1\n");
		/* break */
		case 4:
			printf("case 4\n");
			fallthru common2;
		case 5:
			printf("case 5\n");
			fallthru common2;
			fallthru default;
		case 6:
			printf("case 6\n");
			fallthru common2;
		common2:
			printf("common2\n");
		/* break */
		default:
			printf("default\n");
			fallthru;
	}

#if ERR1
	// ERROR: fallthrough must be enclosed in switch or choose
	fallthru;
	// ERROR: fallthrough must be enclosed in switch or choose
	fallthru common4;
	// ERROR: fallthrough must be enclosed in switch or choose
	fallthru default;
	choose ( 3 ) {
		case 2:
			for ( ;; ) {
				choose ( 2 ) {
					case 1:
						// ERROR: default is later, but in a different switch
						fallthru default;
						// ERROR: common3 is later, but not at the same level as a case clause
						fallthru common3;
				}
				common3: ;
			}
		default:
		case 1:
		common4:
			// ERROR: attempt to jump up with fallthrough
			if ( 7 ) fallthru common4;
			// ERROR: attempt to jump up with fallthrough
			fallthru default;
	}
#endif
}

int main() {
	test(1);
	test(5);
}

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa dtor-early-exit" //
// End: //
