//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// iterator.h -- 
//
// Author           : Richard C. Bilson
// Created On       : Wed May 27 17:56:53 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Nov 19 17:58:28 2015
// Update Count     : 6
//

#ifndef ITERATOR_H
#define ITERATOR_H

// An iterator can be used to traverse a data structure.
context iterator( type iterator_type, type elt_type ) {
	// point to the next element
//	iterator_type ?++( iterator_type * );
	iterator_type ++?( iterator_type * );
	iterator_type --?( iterator_type * );

	// can be tested for equality with other iterators
	int ?==?( iterator_type, iterator_type );
	int ?!=?( iterator_type, iterator_type );

	// dereference to get the pointed-at element
	lvalue elt_type *?( iterator_type );
};

context iterator_for( type iterator_type, type collection_type, type elt_type | iterator( iterator_type, elt_type ) ) {
//	[ iterator_type begin, iterator_type end ] get_iterators( collection_type );
	iterator_type begin( collection_type );
	iterator_type end( collection_type );
};

forall( type iterator_type, type elt_type | iterator( iterator_type, elt_type ) )
void for_each( iterator_type begin, iterator_type end, void (*func)( elt_type ) );

forall( type iterator_type, type elt_type | iterator( iterator_type, elt_type ) )
void for_each_reverse( iterator_type begin, iterator_type end, void (*func)( elt_type ) );

#endif // ITERATOR_H

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa iterator.c" //
// End: //
