//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// LinkageSpec.cc --
//
// Author           : Rodolfo G. Esteves
// Created On       : Sat May 16 13:22:09 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon Dec 16 15:02:29 2019
// Update Count     : 28
//

#include <cassert>
#include <memory>   // for unique_ptr
#include <string>
using namespace std;

#include "LinkageSpec.h"
#include "Common/SemanticError.h"

namespace LinkageSpec {
	Spec update( CodeLocation location, Spec spec, const string * cmd ) {
		assert( cmd );
		unique_ptr<const string> guard( cmd ); // allocated by lexer
		if ( *cmd == "\"Cforall\"" ) {
			spec.is_mangled = true;
			return spec;
		} else if ( *cmd == "\"C\"" ) {
			spec.is_mangled = false;
			return spec;
		} else {
			SemanticError( location, "Invalid linkage specifier " + *cmd );
		} // if
	} // update

	string name( Spec spec ) {
		switch ( spec ) {
		  case Intrinsic: return "intrinsic";
		  case C: return "C";
		  case Cforall: return "Cforall";
		  case AutoGen: return "autogenerated cfa";
		  case Compiler: return "compiler built-in";
		  case BuiltinCFA: return "cfa built-in";
		  case BuiltinC: return "c built-in";
		  default: return "<unnamed linkage spec>";
		} // siwtch
	} // name
} // LinkageSpec

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
