//                               -*- Mode: C -*- 
// 
// Cforall Version 1.0.0 Copyright (C) 2016 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
// 
// math.c -- 
// 
// Author           : Peter A. Buhr
// Created On       : Tue Apr 19 22:23:08 2016
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Apr 21 07:56:49 2016
// Update Count     : 51
// 

#include "math"

//---------------------------------------

extern "C" {
#include <math.h>
#include <complex.h>
} // extern "C"

float cos( float x ) { return cosf( x ); }
long double cos( long double x ) { return cosl( x ); }
float _Complex cos( float _Complex x ) { return ccosf( x ); }
double _Complex cos( double _Complex x ) { return ccos( x ); }
long double _Complex cos( long double _Complex x ) { return ccosl( x ); }

float cosh( float x ) { return coshf( x ); }
long double cosh( long double x ) { return coshl( x ); }
float _Complex cosh( float _Complex x ) { return ccoshf( x ); }
double _Complex cosh( double _Complex x ) { return ccosh( x ); }
long double _Complex cosh( long double _Complex x ) { return ccoshl( x ); }

float acos( float x ) { return acosf( x ); }
long double acos( long double x ) { return acosl( x ); }
float _Complex acos( float _Complex x ) { return cacosf( x ); }
double _Complex acos( double _Complex x ) { return cacos( x ); }
long double _Complex acos( long double _Complex x ) { return cacosl( x ); }

float acosh( float x ) { return acoshf( x ); }
long double acosh( long double x ) { return acoshl( x ); }
float _Complex acosh( float _Complex x ) { return cacoshf( x ); }
double _Complex acosh( double _Complex x ) { return cacosh( x ); }
long double _Complex acosh( long double _Complex x ) { return cacoshl( x ); }

float sin( float x ) { return sinf( x ); }
long double sin( long double x ) { return sinl( x ); }
float _Complex sin( float _Complex x ) { return csinf( x ); }
double _Complex sin( double _Complex x ) { return csin( x ); }
long double _Complex sin( long double _Complex x ) { return csinl( x ); }

float sinh( float x ) { return sinhf( x ); }
long double sinh( long double x ) { return sinhl( x ); }
float _Complex sinh( float _Complex x ) { return csinhf( x ); }
double _Complex sinh( double _Complex x ) { return csinh( x ); }
long double _Complex sinh( long double _Complex x ) { return csinhl( x ); }

float asin( float x ) { return asinf( x ); }
long double asin( long double x ) { return asinl( x ); }
float _Complex asin( float _Complex x ) { return casinf( x ); }
double _Complex asin( double _Complex x ) { return casin( x ); }
long double _Complex asin( long double _Complex x ) { return casinl( x ); }

float asinh( float x ) { return asinhf( x ); }
long double asinh( long double x ) { return asinhl( x ); }
float _Complex asinh( float _Complex x ) { return casinhf( x ); }
double _Complex asinh( double _Complex x ) { return casinh( x ); }
long double _Complex asinh( long double _Complex x ) { return casinhl( x ); }

float tan( float x ) { return tanf( x ); }
long double tan( long double x ) { return tanl( x ); }
float _Complex tan( float _Complex x ) { return ctanf( x ); }
double _Complex tan( double _Complex x ) { return ctan( x ); }
long double _Complex tan( long double _Complex x ) { return ctanl( x ); }

float tanh( float x ) { return tanhf( x ); }
long double tanh( long double x ) { return tanhl( x ); }
float _Complex tanh( float _Complex x ) { return ctanhf( x ); }
double _Complex tanh( double _Complex x ) { return ctanh( x ); }
long double _Complex tanh( long double _Complex x ) { return ctanhl( x ); }

float atan( float x ) { return atanf( x ); }
long double atan( long double x ) { return atanl( x ); }
float _Complex atan( float _Complex x ) { return catanf( x ); }
double _Complex atan( double _Complex x ) { return catan( x ); }
long double _Complex atan( long double _Complex x ) { return catanl( x ); }

float atan( float x, float y ) { return atan2f( x, y ); }
double atan( double x, double y ) { return atan2( x, y ); }
long double atan( long double x, long double y ) { return atan2l( x, y ); }

float atanh( float x ) { return atanhf( x ); }
long double atanh( long double x ) { return atanhl( x ); }
float _Complex atanh( float _Complex x ) { return catanhf( x ); }
double _Complex atanh( double _Complex x ) { return catanh( x ); }
long double _Complex atanh( long double _Complex x ) { return catanhl( x ); }

float exp( float x ) { return expf( x ); }
long double exp( long double x ) { return expl( x ); }
float _Complex exp( float _Complex x ) { return cexpf( x ); }
double _Complex exp( double _Complex x ) { return cexp( x ); }
long double _Complex exp( long double _Complex x ) { return cexpl( x ); }

float log( float x ) { return logf( x ); }
long double log( long double x ) { return logl( x ); }
float _Complex log( float _Complex x ) { return clogf( x ); }
double _Complex log( double _Complex x ) { return clog( x ); }
long double _Complex log( long double _Complex x ) { return clogl( x ); }

float pow( float x, float y ) { return powf( x, y ); }
long double pow( long double x, long double y ) { return powl( x, y ); }
float _Complex pow( float _Complex x, float _Complex y ) { return cpowf( x, y ); }
double _Complex pow( double _Complex x, double _Complex y ) { return cpow( x, y ); }
long double _Complex pow( long double _Complex x, long double _Complex y ) { return cpowl( x, y ); }

float sqrt( float x ) { return sqrtf( x ); }
long double sqrt( long double x ) { return sqrtl( x ); }
float _Complex sqrt( float _Complex x ) { return csqrtf( x ); }
double _Complex sqrt( double _Complex x ) { return csqrt( x ); }
long double _Complex sqrt( long double _Complex x ) { return csqrtl( x ); }

float fabs( float x ) { return fabsf( x ); }
long double fabs( long double x ) { return fabsl( x ); }
float cabs( float _Complex x ) { return cabsf( x ); }
long double cabs( long double _Complex x ) { return cabsl( x ); }

float floor( float x ) { return floorf( x ); }
long double floor( long double x ) { return floorl( x ); }

float ceil( float x ) { return ceilf( x ); }
long double ceil( long double x ) { return ceill( x ); }

//---------------------------------------

float cbrt( float x ) { return cbrtf( x ); }
long double cbrt( long double x ) { return cbrtl( x ); }

float copysign( float x, float y ) { return copysignf( x, y ); }
long double copysign( long double x, long double y ) { return copysignl( x, y ); }

float erf( float x ) { return erff( x ); }
long double erf( long double x ) { return erfl( x ); }

float erfc( float x ) { return erfcf( x ); }
long double erfc( long double x ) { return erfcl( x ); }

float exp2( float x ) { return exp2f( x ); }
long double exp2( long double x ) { return exp2l( x ); }

float expm1( float x ) { return expm1f( x ); }
long double expm1( long double x ) { return expm1l( x ); }

float fdim( float x, float y ) { return fdimf( x, y ); }
long double fdim( long double x, long double y ) { return fdiml( x, y ); }

float fma( float x, float y, float z ) { return fmaf( x, y, z ); }
long double fma( long double x, long double y, long double z ) { return fmal( x, y, z ); }

float ?%?( float x, float y ) { return fmodf( x, y ); }
float fmod( float x, float y ) { return fmodf( x, y ); }
double ?%?( double x, double y ) { return fmod( x, y ); }
long double ?%?( long double x, long double y ) { return fmodl( x, y ); }
long double fmod( long double x, long double y ) { return fmodl( x, y ); }

//[ int, float ] div( float x ) { int i; x = frexpf( x, &i ); return [ i, x ]; }
float frexp( float x, int *ip ) { return frexpf( x, ip ); }
//[ int, double ] div( double x ) { int i; x = frexp( x, &i ); return [ i, x ]; }
//[ int, long double ] div( long double x ) { int i; x = frexpl( x, &i ); return [ i, x ]; }
long double frexp( long double x, int *ip ) { return frexpl( x, ip ); }

float hypot( float x, float y ) { return hypotf( x, y ); }
long double hypot( long double x, long double y ) { return hypotl( x, y ); }

int ilogb( float x ) { return ilogbf( x ); }
int ilogb( long double x ) { return ilogbl( x ); }

float ldexp( float x, int exp2 ) { return ldexpf( x, exp2 ); }
long double ldexp( long double x, int exp2 ) { return ldexpl( x, exp2 ); }

float lgamma( float x ) { return lgammaf( x ); }
long double lgamma( long double x ) { return lgammal( x ); }

float rint( float x ) { return rintf( x ); }
long double rint( long double x ) { return rintl( x ); }
long int rint( float x ) { return lrintf( x ); }
long int rint( double x ) { return lrint( x ); }
long int rint( long double x ) { return lrintl( x ); }
long long int rint( float x ) { return llrintf( x ); }
long long int rint( double x ) { return llrint( x ); }
long long int rint( long double x ) { return llrintl( x ); }

long int lrint( float x ) { return lrintf( x ); }
long int lrint( long double x ) { return lrintl( x ); }
long long int llrint( float x ) { return llrintf( x ); }
long long int llrint( long double x ) { return llrintl( x ); }

float round( float x ) { return roundf( x ); }
long double round( long double x ) { return roundl( x ); }
long int round( float x ) { return lroundf( x ); }
long int round( double x ) { return lround( x ); }
long int round( long double x ) { return lroundl( x ); }
long long int round( float x ) { return llroundf( x ); }
long long int round( double x ) { return llround( x ); }
long long int round( long double x ) { return llroundl( x ); }

long int lround( float x ) { return lroundf( x ); }
long int lround( long double x ) { return lroundl( x ); }
long long int llround( float x ) { return llroundf( x ); }
long long int llround( long double x ) { return llroundl( x ); }

float log10( float x ) { return log10f( x ); }
long double log10( long double x ) { return log10l( x ); }

float log1p( float x ) { return log1pf( x ); }
long double log1p( long double x ) { return log1pl( x ); }

float log2( float x ) { return log2f( x ); }
long double log2( long double x ) { return log2l( x ); }

float logb( float x ) { return logbf( x ); }
long double logb( long double x ) { return logbl( x ); }

float nearbyint( float x ) { return nearbyintf( x ); }
long double nearbyint( long double x ) { return nearbyintl( x ); }

float nextafter( float x, float y ) { return nextafterf( x, y ); }
long double nextafter( long double x, long double y ) { return nextafterl( x, y ); }

float nexttoward( float x, long double y ) { return nexttowardf( x, y ); }
long double nexttoward( long double x, long double y ) { return nexttowardl( x, y ); }

float remainder( float x, float y ) { return remainderf( x, y ); }
long double remainder( long double x, long double y ) { return remainderl( x, y ); }

//[ int, float ] remquo( float x, float y ) { int quo; x = remquof( x, y, &quo ); return [ quo, x ]; }
float remquo( float x, float y, int *quo ) { return remquof( x, y, quo ); }
//[ int, double ] remquo( double x, double y ) { int quo; x = remquo( x, y, &quo ); return [ quo, x ]; }
//[ int, long double ] remquo( long double x, long double y ) { int quo; x = remquol( x, y, &quo ); return [ quo, x ]; }
long double remquo( long double x, long double y, int *quo ) { return remquol( x, y, quo ); }

float scalbn( float x, int exp ) { return scalbnf( x, exp ); }
long double scalbn( long double x, int exp ) { return scalbnl( x, exp ); }
float scalbn( float x, long int exp ) { return scalblnf( x, exp ); }
double scalbn( double x, long int exp ) { return scalbln( x, exp ); }
long double scalbn( long double x, long int exp ) { return scalblnl( x, exp ); }

float scalbln( float x, long int exp ) { return scalblnf( x, exp ); }
long double scalbln( long double x, long int exp ) { return scalblnl( x, exp ); }

float tgamma( float x ) { return tgammaf( x ); }
long double tgamma( long double x ) { return tgammal( x ); }

float trunc( float x ) { return truncf( x ); }
long double trunc( long double x ) { return truncl( x ); }

// Local Variables: //
// mode: c //
// tab-width: 4 //
// End: //
