//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// sum.c -- 
//
// Author           : Richard C. Bilson
// Created On       : Wed May 27 17:56:53 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon Jun  1 20:46:35 2015
// Update Count     : 18
//

extern "C" {
	int printf( const char *, ... );
}

context sumable( type T ) {
	const T 0;
	T ?+?( T, T );
	T ?++( T * );
	T ?+=?( T *, T );
};

forall( type T | sumable( T ) )
T sum( int n, T a[] ) {
	T total;											// instantiate T, select 0
	total = 0;
	for ( int i = 0; i < n; i += 1 )
		total = total + a[i];							// select +
	return total;
}

// Required to satisfy sumable as char does not have addition.
const char 0;
char ?+?( char op1, char op2 ) { return op1 + op2; }
char ?++( char *op ) { return *op + 1; }

const double 0; // TEMPORARY, incorrect use of int 0

int main() {
	const int low = 5, High = 15, size = High - low;
	int si = 0, ai[size];
	int v = low;
	for ( int i = 0; i < size; i += 1, v += 1 ) {
		si += v;
		ai[i] = v;
	}
	printf( "sum from %d to %d is %d, check %d\n",
			low, High, sum( size, ai ), si );

//	char ci[size];
//	char c = sum( size, ci );
//	float fi[size];
//	float f = sum( size, fi );

	double sd = 0.0, ad[size];
	double v = low / 10.0;
	for ( int i = 0; i < size; i += 1, v += 0.1 ) {
		sd += v;
		ad[i] = v;
	}
	printf( "sum from %g to %g is %g, check %g\n",
			low / 10.0, High / 10.0, sum( size, ad ), sd );
}

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa sum.c" //
// End: //
