#include <algorithm>
#include "bench.hpp"
#include "cpp-vstack.hpp"
#include "object.hpp"

int main(int argc, char** argv) {
	integer maxi{ 0 }, vali{ 42 };
	stack si, ti;
	
	REPEAT_TIMED( "push_int", N, si.push( vali ); )
	TIMED( "copy_int", ti = si; )
	TIMED( "clear_int", si.clear(); )
	REPEAT_TIMED( "pop_int", N, maxi = std::max( maxi, ti.pop()->as<integer>() ); /***/ )

	ptr<pair> maxp = make<pair>( make<boolean>(false), make<character>('\0') );
	pair valp{ make<boolean>(true), make<character>('a') };
	stack sp, tp;
	
	REPEAT_TIMED( "push_pair", N, sp.push( valp ); )
	TIMED( "copy_pair", tp = sp; )
	TIMED( "clear_pair", sp.clear(); )
	REPEAT_TIMED( "pop_pair", N, 
		ptr<pair> xp = as_ptr<pair>( tp.pop() ); /***/
		if ( *xp > *maxp ) { maxp = std::move(xp); } )
}
