#pragma once
#include <stdio.h>
#include <time.h>

long ms_between(clock_t start, clock_t end) { return (end - start) / (CLOCKS_PER_SEC / 1000); }

#ifndef N
#define N 40000000
#endif

#define TIMED(name, code) { \
	volatile clock_t _start, _end; \
	_start = clock(); \
	code \
	_end = clock(); \
	printf("%s:\t%8ld ms\n", name, ms_between(_start, _end)); \
}
#define REPEAT_TIMED(name, n, code) TIMED( name, for (int _i = 0; _i < n; ++_i) { code } )
