//                               -*- Mode: C -*- 
// 
// Cforall Version 1.0.0 Copyright (C) 2016 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
// 
// io.c -- 
// 
// Author           : Peter A. Buhr
// Created On       : Wed Mar  2 16:56:02 2016
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed Apr 13 23:03:14 2016
// Update Count     : 22
// 

#include <fstream>

int main() {
	char c;														// basic types
	short int si;
	unsigned short int usi;
	int i;
	unsigned int ui;
	long int li;
	unsigned long int uli;
	long long int lli;
	unsigned long long int ulli;
	float f;
	double d;
	long double ld;
	float _Complex fc;
	double _Complex dc;
	long double _Complex ldc;
	char s1[10], s2[10];

	ifstream in;												// create / open file
	open( &in, "io.data", "r" );

	&in | &c													// character
		| &si | &usi | &i | &ui | &li | &uli | &lli | &ulli		// integral
		| &f | &d | &ld											// floating point
		| &fc | &dc | &ldc										// floating-point complex
		| cstr( s1 ) | cstr( s2, 10 );							// C string, length unchecked and checked

	sout | c | ' ' | endl										// character
		 | si | usi | i | ui | li | uli | lli | ulli | endl		// integral
		 | f | d | ld | endl									// floating point
		 | fc | dc | ldc | endl;								// complex
	sout | endl;
	sout | f | "" | d | "" | ld | endl							// floating point without separator
		 | sepDisable | fc | dc | ldc | sepEnable | endl		// complex without separator
		 | sepOn | s1 | sepOff | s2 | endl						// local separator removal
		 | s1 | "" | s2 | endl;									// C string withou separator
	sout | endl;

	sepSet( sout, ", $" );										// change separator, maximum of 15 characters
	sout | f | d | ld | endl									// floating point without separator
		 | fc | dc | ldc | endl									// complex without separator
		 | s1 | s2 | endl;
	sout | endl;
	sepSet( sout, " " );

	sout
		// opening delimiters
		| "v(" | 27
		| "v[" | 27
		| "v{" | 27
		| "$" | 27
		| "" | 27
		| "" | 27
		| "" | 27
		| "" | 27
		| endl
		// closing delimiters
		| 25 | ","
		| 25 | "."
		| 25 | ":"
		| 25 | ";"
		| 25 | "!"
		| 25 | "?"
		| 25 | ")"
		| 25 | "]"
		| 25 | "}"
		| 25 | "%"
		| 25 | ""
		| 25 | ""
		| endl
		// opening-closing delimiters
		| 25 | "'" | 27
		| 25 | "`" | 27
		| 25 | "\"" | 27
		| 25 | "\f" | 27
		| 25 | "\n" | 27
		| 25 | "\r" | 27
		| 25 | "\t" | 27
		| 25 | "\v" | 27
		| endl;
}

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa io.c" //
// End: //
