#!/usr/bin/awk -f

BEGIN {
	pattern = "^" path "[0-9A-z]*\\.(cc|h)"
	complete_pattern = "^\\(" path "[0-9A-z]*\\.(cc|h)"
	show = 0
}

$1 !~ /^(Makefile.*|Making.*|CXX)/ {
	if( $1 ~ pattern ) {
		show = 1
	}

	if( $1 ~ complete_pattern ) {
		print
	}

	if( show > 0 )
	{
		print
	}
}

$1 ~ /^---/ {
	show = 0
}

$1 ~ /^CXX/ {
	$1 = "  IWYU   "
	print > "/dev/stderr"
}