//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// RenameVars.h --
//
// Author           : Richard C. Bilson
// Created On       : Sun May 17 12:10:28 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Sat Jul 22 09:33:54 2017
// Update Count     : 4
//

#pragma once

#include <list>               // for list
#include <map>                // for map
#include <string>             // for string

#include "SynTree/SynTree.h"  // for Visitor Nodes
#include "SynTree/Visitor.h"  // for Visitor

namespace ResolvExpr {

	/// Provides a consistent renaming of forall type names in a hierarchy by prefixing them with a unique "level" ID
	class RenameVars : public Visitor {
	  public:
		RenameVars();
		void reset();
	  private:
		virtual void visit( VoidType *basicType );
		virtual void visit( BasicType *basicType );
		virtual void visit( PointerType *pointerType );
		virtual void visit( ArrayType *arrayType );
		virtual void visit( FunctionType *functionType );
		virtual void visit( StructInstType *aggregateUseType );
		virtual void visit( UnionInstType *aggregateUseType );
		virtual void visit( EnumInstType *aggregateUseType );
		virtual void visit( TraitInstType *aggregateUseType );
		virtual void visit( TypeInstType *aggregateUseType );
		virtual void visit( TupleType *tupleType );
		virtual void visit( VarArgsType *varArgsType );
		virtual void visit( ZeroType *zeroType );
		virtual void visit( OneType *oneType );

		void typeBefore( Type *type );
		void typeAfter( Type *type );
		int level;
		std::list< std::map< std::string, std::string > > mapStack;
	};

	extern RenameVars global_renamer;
} // namespace ResolvExpr

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
