//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Occurs.cc -- 
//
// Author           : Richard C. Bilson
// Created On       : Sun May 17 09:47:41 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Sun May 17 09:49:26 2015
// Update Count     : 2
//

#include <set>                // for set, _Rb_tree_const_iterator
#include <string>             // for string

#include "SynTree/Type.h"     // for TypeInstType, Type
#include "SynTree/Visitor.h"  // for Visitor
#include "TypeEnvironment.h"  // for EqvClass, TypeEnvironment

namespace ResolvExpr {
	class Occurs : public Visitor {
	  public:
		Occurs( std::string varName, const TypeEnvironment &env );
		bool get_result() const { return result; }
		virtual void visit( TypeInstType *typeInst );
	  private:
		bool result;
		std::set< std::string > eqvVars;
		const TypeEnvironment &env;
	};

	bool occurs( Type *type, std::string varName, const TypeEnvironment &env ) {
		Occurs occur( varName, env );
		type->accept( occur );
		return occur.get_result();
	}

	Occurs::Occurs( std::string varName, const TypeEnvironment &env ) : result( false ), env( env ) {
		EqvClass eqvClass;
		if ( env.lookup( varName, eqvClass ) ) {
			eqvVars = eqvClass.vars;
		} else {
			eqvVars.insert( varName );
		} // if
	}

	void Occurs::visit( TypeInstType *typeInst ) {
		EqvClass eqvClass;
///   std::cout << "searching for vars: ";
///   std::copy( eqvVars.begin(), eqvVars.end(), std::ostream_iterator< std::string >( std::cout, " " ) );
///   std::cout << std::endl;
		if ( eqvVars.find( typeInst->get_name() ) != eqvVars.end() ) {
			result = true;
		} else if ( env.lookup( typeInst->get_name(), eqvClass ) ) {
			if ( eqvClass.type ) {
///       std::cout << typeInst->get_name() << " is bound to";
///       eqvClass.type->print( std::cout );
///       std::cout << std::endl;
				eqvClass.type->accept( *this );
			} // if
		} // if
	}
} // namespace ResolvExpr

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
