//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// VarExprReplacer.h --
//
// Author           : Rob Schluntz
// Created On       : Wed Jan 13 16:29:30 2016
// Last Modified By : Rob Schluntz
// Last Modified On : Fri May 13 11:27:52 2016
// Update Count     : 5
//

#include <iostream>       // for operator<<, basic_ostream, ostream, basic_o...

#include "Declaration.h"  // for operator<<, DeclarationWithType
#include "Expression.h"   // for VariableExpr
#include "VarExprReplacer.h"

VarExprReplacer::VarExprReplacer( const DeclMap & declMap, bool debug ) : declMap( declMap ), debug( debug ) {}

// replace variable with new node from decl map
void VarExprReplacer::visit( VariableExpr * varExpr ) {
	// xxx - assertions and parameters aren't accounted for in this... (i.e. they aren't inserted into the map when it's made, only DeclStmts are)
	if ( declMap.count( varExpr->get_var() ) ) {
		if ( debug ) {
			std::cerr << "replacing variable reference: " << (void*)varExpr->get_var() << " " << varExpr->get_var() << " with " << (void*)declMap.at( varExpr->get_var() ) << " " << declMap.at( varExpr->get_var() ) << std::endl;
		}
		varExpr->set_var( declMap.at( varExpr->get_var() ) );
	}
}
