struct S {
	var i : Int,  j : Int
}
var s = S( i : 3, j : 5 )
enum ADT {
	case I(Int)   // int
	case F(Float) // float
	case S(S)     // struct
}
var adt : ADT
adt = ADT.I( 3 );  print( adt )
adt = .F( 3.5 );  print( adt )
adt = .S( s );  print( adt )
switch adt {
	case .I(let i):  print( i )
	case .F(let f):  print( f )
	case .S(let s):  print( s.i, s.j )
}

enum Week: Comparable {
	case Mon, Tue, Wed, Thu, Fri, Sat, Sun // unit-type
	func isWeekday() -> Bool { return self <= .Fri }  // method
	func isWeekend() -> Bool { return .Sat <= self }  // method
};
var week : Week = Week.Mon;

if week == .Mon {
	print( week );
}
if week <= .Fri {
	print( "weekday" );
}
if .Sat < week {
	print( "weekend" );
}
switch week { // exhaustive
	case .Mon: print( "Mon" )
	case .Tue: print( "Tue" )
	case .Wed: print( "Wed" )
	case .Thu: print( "Thu" )
	case .Fri: print( "Fri" )
	case .Sat: print( "Sat" )
	case .Sun: print( "Sun" )
}

enum WeekI: Comparable, CaseIterable {
	case Mon, Tue, Wed, Thu, Fri, Sat, Sun // unit-type
};
var weeki : WeekI = WeekI.Mon;
if weeki <= .Fri {
	print( "weekday" );
}
for day in WeekI.allCases { 
	print( day, terminator:" " ) 
}
print( "" )

print( WeekI.allCases.count, WeekI.allCases )

enum WeekInt: Int, CaseIterable {
	case Mon, Tue, Wed, Thu = 10, Fri = 14,
			Sat = 4, Sun // auto-incrementing
};
var weekInt : WeekInt = WeekInt.Mon;
print( WeekInt.Thu.rawValue );
for day in WeekInt.allCases {
	print( day.rawValue, terminator:" " ) 
}
print( "" )

enum WeekStr: String, CaseIterable {
	case Mon = "MON", Tue, Wed, Thu, Fri,
			Sat = "SAT", Sun
};
for day in WeekStr.allCases { 
	print( day.rawValue, terminator:" " ) 
}
print( "" )

if let opt = WeekInt( rawValue: 0 ) {
	print( weekInt.rawValue, opt )
} else {
	print( "invalid weekday lookup" )
}

// Local Variables: //
// compile-command: "swift test.swift" //
// End: //
