//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// NamedTypeDecl.cc --
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Mar 16 07:49:44 2017
// Update Count     : 13
//

#include "Declaration.h"
#include "Type.h"
#include "Common/utility.h"

NamedTypeDecl::NamedTypeDecl( const std::string &name, Type::StorageClasses scs, Type *base )
	: Parent( name, scs, LinkageSpec::Cforall ), base( base ) {}

NamedTypeDecl::NamedTypeDecl( const NamedTypeDecl &other )
	: Parent( other ), base( maybeClone( other.base ) ) {
	cloneAll( other.parameters, parameters );
	cloneAll( other.assertions, assertions );
}

NamedTypeDecl::~NamedTypeDecl() {
	delete base;
	deleteAll( parameters );
	deleteAll( assertions );
}

void NamedTypeDecl::print( std::ostream &os, int indent ) const {
	using namespace std;

	if ( get_name() != "" ) {
		os << get_name() << ": ";
	} // if
	get_storageClasses().print( os );
	os << typeString();
	if ( base ) {
		os << " for ";
		base->print( os, indent );
	} // if
	if ( ! parameters.empty() ) {
		os << endl << string( indent, ' ' ) << "with parameters" << endl;
		printAll( parameters, os, indent+2 );
	} // if
	if ( ! assertions.empty() ) {
		os << endl << string( indent, ' ' ) << "with assertions" << endl;
		printAll( assertions, os, indent+2 );
	} // if
}

void NamedTypeDecl::printShort( std::ostream &os, int indent ) const {
	using namespace std;

	if ( get_name() != "" ) {
		os << get_name() << ": ";
	} // if
	get_storageClasses().print( os );
	os << typeString();
	if ( base ) {
		os << " for ";
		base->print( os, indent );
	} // if
	if ( ! parameters.empty() ) {
		os << endl << string( indent, ' ' ) << "with parameters" << endl;
		printAll( parameters, os, indent+2 );
	} // if
}

std::string TypedefDecl::typeString() const { return "typedef"; }

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
