// I Compile-time resolution
// =========================
// 
// 1. an isolated name, where the argument is implicitly determined by the result context
// 
//    @max
// 
// 2. a direct application to a manifest type
// 
//    @max( int )
// 
// 3. constraining a type variable; the application is implicitly performed at the call site as in (2)
// 
//    forall( type T | { T @max( T ); } ) T x( T t );
// 
// 
// II Run-time resolution
// ======================
// 
// 1. an indirect reference, where the argument is implicitly determined by the result context
// 
//    attr_var = &@max;
//    x = (*attr_var);
// 
// 2. an indirect application to a manifest type
// 
//    (*attr_var)( int )
// 
// 3. a direct application to a type variable
// 
//    @max( T )
// 
// Under what circumstances can this be done at compile/link time?
// 
// 
// III Declaration forms
// =====================
// 
// 1. monomorphic with implicit argument
// 
//    int @max;
// 
// 2. monomorphic with explicit argument
// 
//    int @max( int );
// 
// 3. polymorphic
// 
//    forall( type T | constraint( T ) ) int @attr( T );

int @max = 3;

int main() {
    int x;
    type @type(type t);									// compiler intrinsic
    type @widest(type t);
    @type(x) *y;										// gcc: typeof(x) *y;
    const @widest(double) *w;							// gcc: const typeof(x) *w;
    * @type(3 + 4) z;									// cfa declaration syntax
    y = @max;		
    z = @max(x) + @size(int);
    y = @min(3 + 4);
    if ( @const(x) ) { }
    if ( @volatile(y) ) { }
    if ( @extern(y) ) { }
    if ( @static(y) ) { }
    @max;
}

int @foo(int) {
    return 7;
}

int @voon;
double @voon;

int @bort(int);
int @bort(double);

void g( int );

void f() {
	float x;
	double x;
	@bort(x);
	@bort(int);
	g( @voon );
}

// Local Variables: //
// tab-width: 4 //
// End: //
