//
// Cforall Version 1.0.0 Copyright (C) 2018 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Heap.cc --
//
// Author           : Peter A. Buhr
// Created On       :
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu May  3 16:16:10 2018
// Update Count     : 2
//

#include <cassert>
#include <cmath>
#include <cstddef>
#include <cstring>
#include <iomanip>
#include <iostream>

namespace HeapStats {
	#if !defined( WITH_HEAP_STATISTICS )
		void newPass( const char * const ) {}

		void printStats() {}
	#else
		struct StatBlock {
			const char * name = nullptr;
			size_t mallocs    = 0;
			size_t frees      = 0;
		};

		StatBlock    passes[100];
		const size_t passes_size = sizeof(passes) / sizeof(passes[0]);
		size_t       passes_cnt = 0;

		void newPass( const char * const name ) {
			passes[passes_cnt].name    = name;
			passes[passes_cnt].mallocs = 0;
			passes[passes_cnt].frees   = 0;
			passes_cnt++;

			assertf(passes_cnt < passes_size, "Too many passes for HeapStats, increase the size of the array in Heap.h");
		}

		void print(size_t value, size_t total) {
			std::cerr << std::setw(12) << value;
			std::cerr << "(" << std::setw(3);
			std::cerr << (value == 0 ? 0 : value * 100 / total);
			std::cerr << "%) | ";
		}

		void print(const StatBlock& stat, size_t nc, size_t total_mallocs, size_t total_frees) {
			std::cerr << std::setw(nc) << stat.name;
			std::cerr << " | ";

			print(stat.mallocs, total_mallocs);
			print(stat.frees  , total_frees  );
			std::cerr << "\n";
		}

		void print(char c, size_t nc) {
			for(size_t i = 0; i < nc; i++) {
				std::cerr << c;
			}
			std::cerr << '\n';
		}

		void printStats() {
			size_t nc = 0;
			size_t total_mallocs = 0;
			size_t total_frees   = 0;
			for(size_t i = 0; i < passes_cnt; i++) {
				nc = std::max(nc, std::strlen(passes[i].name));
				total_mallocs += passes[i].mallocs;
				total_frees   += passes[i].frees;
			}
			size_t nct = nc + 44;

			const char * const title = "Heap Usage Statistic";
			print('=', nct);
			for(size_t i = 0; i < (nct - std::strlen(title)) / 2; i++) std::cerr << ' ';
			std::cerr << title << std::endl;
			print('-', nct);
			std::cerr << std::setw(nc) << "Pass";
			std::cerr << " |       Malloc Count |         Free Count |" << std::endl;

			print('-', nct);
			for(size_t i = 0; i < passes_cnt; i++) {
				print(passes[i], nc, total_mallocs, total_frees);
			}
			print('-', nct);
			print({"Sum", total_mallocs, total_frees}, nc, total_mallocs, total_frees);

		}
	#endif
}

