//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// ObjectDecl.cc --
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Rob Schluntz
// Last Modified On : Tue Feb 09 13:21:03 2016
// Update Count     : 30
//

#include "Declaration.h"
#include "Type.h"
#include "Initializer.h"
#include "Expression.h"
#include "Common/utility.h"
#include "Statement.h"

ObjectDecl::ObjectDecl( const std::string &name, DeclarationNode::StorageClass sc, LinkageSpec::Type linkage, Expression *bitfieldWidth, Type *type, Initializer *init, bool isInline, bool isNoreturn )
	: Parent( name, sc, linkage ), type( type ), init( init ), bitfieldWidth( bitfieldWidth ) {
	set_isInline( isInline );
	set_isNoreturn( isNoreturn );
}

ObjectDecl::ObjectDecl( const ObjectDecl &other )
	: Parent( other ), type( maybeClone( other.type ) ), init( maybeClone( other.init ) ), bitfieldWidth( maybeClone( other.bitfieldWidth ) ) {
}

ObjectDecl::~ObjectDecl() {
	delete type;
	delete init;
	delete bitfieldWidth;
}

void ObjectDecl::print( std::ostream &os, int indent ) const {
	if ( get_name() != "" ) {
		os << get_name() << ": ";
	} // if

	if ( get_linkage() != LinkageSpec::Cforall ) {
		os << LinkageSpec::toString( get_linkage() ) << " ";
	} // if

	if ( get_storageClass() != DeclarationNode::NoStorageClass ) {
		os << DeclarationNode::storageName[ get_storageClass() ] << ' ';
	} // if

	if ( get_type() ) {
		get_type()->print( os, indent );
	} else {
		os << " untyped entity ";
	} // if

	if ( init ) {
		os << " with initializer ";
		init->print( os, indent );
		os << std::string(indent, ' ') << "maybeConstructed? " << init->get_maybeConstructed();
	} // if

	if ( bitfieldWidth ) {
		os << " with bitfield width ";
		bitfieldWidth->print( os );
	} // if
}

void ObjectDecl::printShort( std::ostream &os, int indent ) const {
#if 0
	if ( get_mangleName() != "") {
		os << get_mangleName() << ": ";
	} else
#endif
	if ( get_name() != "" ) {
		os << get_name() << ": ";
	} // if

	if ( get_storageClass() != DeclarationNode::NoStorageClass ) {
		os << DeclarationNode::storageName[ get_storageClass() ] << ' ';
	} // if

	if ( get_type() ) {
		get_type()->print( os, indent );
	} else {
		os << "untyped entity ";
	} // if

	if ( bitfieldWidth ) {
		os << "with bitfield width ";
		bitfieldWidth->print( os );
	} // if
}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
