//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Declaration.h --
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Sat Jul 22 09:54:14 2017
// Update Count     : 39
//

#pragma once

#include "SynTree.h"

// GCC attribute
// https://gcc.gnu.org/onlinedocs/gcc-6.1.0/gcc/Attribute-Syntax.html#Attribute-Syntax
class Attribute {
  public:
	Attribute( std::string name = "", const std::list< Expression * > & parameters = std::list< Expression * >() ) : name( name ), parameters( parameters ) {}
	Attribute( const Attribute &other );
	virtual ~Attribute();

	std::string get_name() const { return name; }
	void set_name( const std::string & newValue ) { name = newValue; }
	std::list< Expression * > & get_parameters() { return parameters; }
	bool empty() const { return name == ""; }

	Attribute * clone() const { return new Attribute( *this ); }
	void print( std:: ostream &os, int indent = 0 ) const;
  private:
	std::string name;
	// to keep things nice and tight, use NameExpr for special identifier parameters
	std::list< Expression * > parameters;
};

const std::list< Attribute * > noAttributes;

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
