//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Print.hpp --
//
// Author           : Thierry Delisle
// Created On       : Tue May 21 16:20:15 2019
// Last Modified By :
// Last Modified On :
// Update Count     :
//

#pragma once

#include <iosfwd>
#include <utility> // for forward

#include "AST/Node.hpp"
#include "Common/Indenter.h"

namespace ast {

class Decl;

/// Print a node with the given indenter
void print( std::ostream & os, const ast::Node * node, Indenter indent = {} );

/// Wrap any standard format printer (matching above) with integer Indenter constructor
template<typename T>
inline void print( std::ostream & os, T && x, unsigned int indent ) {
    print( os, std::forward<T>(x), Indenter{ Indenter::tabsize, indent });
}

/// Print a declaration in its short form
void printShort( std::ostream & os, const ast::Decl * node, Indenter indent = {} );

inline void printShort( std::ostream & os, const ast::Decl * node, unsigned int indent ) {
    printShort( os, node, Indenter{ Indenter::tabsize, indent } );
}

}