//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Alternative.h --
//
// Author           : Richard C. Bilson
// Created On       : Sat May 16 23:45:43 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Sat May 16 23:54:39 2015
// Update Count     : 2
//

#ifndef ALTERNATIVE_H
#define ALTERNATIVE_H

#include <list>
#include "SynTree/SynTree.h"
#include "Cost.h"
#include "TypeEnvironment.h"

namespace ResolvExpr {
	struct Alternative;
	typedef std::list< Alternative > AltList;

	struct Alternative {
		Alternative();
		Alternative( Expression *expr, const TypeEnvironment &env, const Cost &cost );
		Alternative( Expression *expr, const TypeEnvironment &env, const Cost &cost, const Cost &cvtCost );
		Alternative( const Alternative &other );
		Alternative &operator=( const Alternative &other );
		Alternative( Alternative && other );
		Alternative &operator=( Alternative && other );
		~Alternative();

		void initialize( const Alternative &src, Alternative &dest );

		void print( std::ostream &os, int indent = 0 ) const;

		Cost cost;
		Cost cvtCost;
		Expression *expr;
		TypeEnvironment env;
	};
} // namespace ResolvExpr

#endif // ALTERNATIVE_H

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
