//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Type.cc --
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Mar 16 07:57:45 2017
// Update Count     : 20
//

#include "SynTree.h"
#include "Visitor.h"
#include "Type.h"
#include "Declaration.h"
#include "Attribute.h"
#include "Common/utility.h"

using namespace std;

const char *BasicType::typeNames[BasicType::NUMBER_OF_BASIC_TYPES] = {
	"_Bool",
	"char",
	"char",
	"unsigned char",
	"short",
	"short unsigned",
	"int",
	"unsigned int",
	"long int",
	"long unsigned int",
	"long long int",
	"long long unsigned int",
	"float",
	"double",
	"long double",
	"float _Complex",
	"double _Complex",
	"long double _Complex",
	"float _Imaginary",
	"double _Imaginary",
	"long double _Imaginary",
};

Type::Type( const Qualifiers &tq, const std::list< Attribute * > & attributes ) : tq( tq ), attributes( attributes ) {}

Type::Type( const Type &other ) : tq( other.tq ) {
	cloneAll( other.forall, forall );
	cloneAll( other.attributes, attributes );
}

Type::~Type() {
	deleteAll( forall );
	deleteAll( attributes );
}

// These must remain in the same order as the corresponding bit fields.
const char * Type::StorageClasses::Names[] = { "extern", "static", "auto", "register", "_Thread_local" };
const char * Type::Qualifiers::Names[] = { "const", "restrict", "volatile", "lvalue", "mutex", "_Atomic" };

void Type::print( std::ostream &os, int indent ) const {
	if ( ! forall.empty() ) {
		os << "forall" << std::endl;
		printAll( forall, os, indent + 4 );
		os << std::string( indent+2, ' ' );
	} // if

	if ( ! attributes.empty() ) {
		os << endl << string( indent+2, ' ' ) << "with attributes" << endl;
		printAll( attributes, os, indent+4 );
	} // if
	
	tq.print( os, indent );
}

std::ostream & operator<<( std::ostream & out, const Type * type ) {
	if ( type ) {
		type->print( out );
	} else {
		out << "nullptr";
	} // if
	return out;
}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
