#include <glm/glm.hpp>
#include <iostream>
#include <ostream>

using namespace glm;

std::ostream& operator<<(std::ostream& os, glm::tvec4<float>& v) {
    os << "<" << v.x << "," << v.y << "," << v.z << "," << v.w << ">";
    return os;
}
std::ostream& operator<<(std::ostream& os, glm::tvec4<float>&& v) {
    os << "<" << v.x << "," << v.y << "," << v.z << "," << v.w << ">";
    return os;
}

float length_squared(glm::tvec4<float> v) {
    return glm::length(v) * glm::length(v);
}

tvec4<float> project(glm::tvec4<float> u, glm::tvec4<float> v) {
    return normalize(v) * dot(u, normalize(v));
}

int main(void) {
    tvec4<float> v1 = {1.f,2.f,3.f,4.f};
    std::cout << "ctor(x,y):" << v1 << std::endl;

    tvec4<float> v2 = v1;
    std::cout << "copy ctor:" << v2 << std::endl;

    v2 = (tvec4<float>){3.f,4.2f,-2.f,-100.f};
    std::cout << "assignment:" << v2 << std::endl;

    v2 = v1;
    std::cout << "move assignment:" << v2 << std::endl;

    // tvec4<float> v3 = 0;
    // std::cout << "zero-init:" << v3 << std::endl;

    // v1 = 0;
    // std::cout << "zero-assign:" << v1 << std::endl;
    //
    // tvec4<float> v4 = {1.23f};
    // std::cout << "fill-ctor:" << v4 << std::endl;
    //
    v1 = (tvec4<float>){1.23f, 3.43f, 0.000002f, -0.000002f};
    std::cout << "?-?:" << (v1 - (tvec4<float>){1.21f,3,1,-0.000001f}) << std::endl;

    v1 -= (tvec4<float>){1.21f,3,1,-0.000001f};
    std::cout << "?-=?:" << v1 << std::endl;

    v1 = -v1;
    std::cout << "-?:" << v1 << std::endl;


    v1 = (tvec4<float>){1.5f, 2.75f, -14.2f, -13.5f};
    std::cout << "?+?:" << (v1 + (tvec4<float>){0.8f, -0.3f, 5, 1}) << std::endl;

    v1 += (tvec4<float>){0.8f, -0.3f, 5, 1};
    std::cout << "?+=?:" << v1 << std::endl;

    v1 = (tvec4<float>){1.5f, 2.75f, 100.3f, -2.f};
    std::cout << "v*s:" << v1 * 3.f << std::endl;

    std::cout << "s*v:" << 3.f * v1 << std::endl;

    v1 *= 3;
    std::cout << "?*=?:" << v1 << std::endl;

    v1 = (tvec4<float>){2, -0.1f, 45, -15};
    std::cout << "?/?:" << (v1 / 3.f) << std::endl;

    v1 /= 3.f;
    std::cout << "?/=?:" << v1 << std::endl;


    v1 = (tvec4<float>){4,3,2,1};
    v2 = (tvec4<float>){0,4,-3,-6};
    std::cout << "dot_1:" << dot(v1, v2) << std::endl;

    v2 = (tvec4<float>){1.3f, -2, 12.2, 24.1345};
    std::cout << "dot_2:" << dot(v1, v2) << std::endl;


    v1 = (tvec4<float>){1,2,3,4};
    std::cout << "length:" << length(v1) << std::endl;

    std::cout << "length_squared:" << length_squared(v1) << std::endl;

    v2 = (tvec4<float>){6, -3.2f, 1, 12};
    std::cout << "distance:" << distance(v1, v2) << std::endl;

    std::cout << "normalize:" << normalize(v2) << std::endl;

    std::cout << "project:" << project((tvec4<float>){5,6,0,-1}, (tvec4<float>){0, 0, 0, 1}) << std::endl;
    std::cout << "project_2:" << project((tvec4<float>){5,6,3.2f,-16.75f}, (tvec4<float>){10, 1, 4, 2}) << std::endl;

    v1 = (tvec4<float>){5,6,2.333f,1};
    v2 = (tvec4<float>){1,0,-13.5f,2};
    std::cout << "reflect:" << reflect(v1,normalize(v2)) << std::endl;

    v2 = (tvec4<float>){0,-1,2,0.5f};
    std::cout << "refract:" << refract(normalize(v1),normalize(v2),1.f) << std::endl;
    std::cout << "refract:" << refract(normalize(v1),normalize(v2),1.f/1.33f) << std::endl;

    tvec4<float> geometric_normal = {5,6,1,2};
    tvec4<float> perturbed_normal = {4,5.5f,2,2};
    tvec4<float> eyeline = {-1,0.002f,-1.0345f,-2};
    std::cout << "faceforward_nochange:" << faceforward(perturbed_normal, eyeline, geometric_normal) << std::endl;

    eyeline = (tvec4<float>){1,0.002f,-1.0345f,-2};
    std::cout << "faceforward_flip:" << faceforward(perturbed_normal, eyeline, geometric_normal) << std::endl;
}

