#include <glm/glm.hpp>
#include <iostream>
#include <ostream>

using namespace glm;

std::ostream& operator<<(std::ostream& os, glm::tvec3<float>& v) {
    os << "<" << v.x << "," << v.y << "," << v.z << ">";
    return os;
}
std::ostream& operator<<(std::ostream& os, glm::tvec3<float>&& v) {
    os << "<" << v.x << "," << v.y << "," << v.z << ">";
    return os;
}

float length_squared(glm::tvec3<float> v) {
    return glm::length(v) * glm::length(v);
}

tvec3<float> project(glm::tvec3<float> u, glm::tvec3<float> v) {
    return normalize(v) * dot(u, normalize(v));
}

int main(void) {
    tvec3<float> v1 = {1.f,2.f,3.f};
    std::cout << "ctor(x,y):" << v1 << std::endl;

    tvec3<float> v2 = v1;
    std::cout << "copy ctor:" << v2 << std::endl;

    v2 = (tvec3<float>){3.f, 4.2f, -2.f};
    std::cout << "assignment:" << v2 << std::endl;

    v2 = v1;
    std::cout << "move assignment:" << v2 << std::endl;

    // tvec3<float> v3 = 0;
    // std::cout << "zero-init:" << v3 << std::endl;

    // v1 = 0;
    // std::cout << "zero-assign:" << v1 << std::endl;
    //
    // tvec3<float> v4 = {1.23f};
    // std::cout << "fill-ctor:" << v4 << std::endl;
    //
    v1 = (tvec3<float>){1.23f, 3.43f, 0.000002f};
    std::cout << "?-?:" << (v1 - (tvec3<float>){1.21f,3,1}) << std::endl;

    v1 -= (tvec3<float>){1.23f, 3.43f, 0.000002f};
    std::cout << "?-=?:" << v1 << std::endl;

    v1 = -v1;
    std::cout << "-?:" << v1 << std::endl;





    v1 = (tvec3<float>){1.5f, 2.75f, -14.2f};
    std::cout << "?+?:" << (v1 + (tvec3<float>){0.8f, -0.3f, 5}) << std::endl;

    v1 += (tvec3<float>){0.8f, -0.3f, 5};
    std::cout << "?+=?:" << v1 << std::endl;

    v1 = (tvec3<float>){1.5f, 2.75f, 100.3f};
    std::cout << "v*s:" << v1 * 3.f << std::endl;

    std::cout << "s*v:" << 3.f * v1 << std::endl;

    v1 *= 3;
    std::cout << "?*=?:" << v1 << std::endl;

    v1 = (tvec3<float>){2, -0.1f, 45};
    std::cout << "?/?:" << (v1 / 3.f) << std::endl;

    v1 /= 3.f;
    std::cout << "?/=?:" << v1 << std::endl;


    v1 = (tvec3<float>){4,2,3};
    v2 = (tvec3<float>){0,-3,2};
    std::cout << "dot_1:" << dot(v1, v2) << std::endl;

    v2 = (tvec3<float>){1.3f, -2, 12.2};
    std::cout << "dot_2:" << dot(v1, v2) << std::endl;


    v1 = (tvec3<float>){1,2,3};
    std::cout << "length:" << length(v1) << std::endl;

    std::cout << "length_squared:" << length_squared(v1) << std::endl;

    v2 = (tvec3<float>){6, -3.2f, 1};
    std::cout << "distance:" << distance(v1, v2) << std::endl;

    std::cout << "normalize:" << normalize(v2) << std::endl;

    std::cout << "project:" << project((tvec3<float>){5,6,0}, (tvec3<float>){0, 0, 1}) << std::endl;
    std::cout << "project_2:" << project((tvec3<float>){5,6,3.2f}, (tvec3<float>){10, 1, 4}) << std::endl;

    v1 = (tvec3<float>){5,6,2.333f};
    v2 = (tvec3<float>){1,0,-13.5f};
    std::cout << "reflect:" << reflect(v1,normalize(v2)) << std::endl;

    v2 = (tvec3<float>){0,-1,2};
    std::cout << "refract:" << refract(normalize(v1),normalize(v2),1.f) << std::endl;
    std::cout << "refract:" << refract(normalize(v1),normalize(v2),1.f/1.33f) << std::endl;

    tvec3<float> geometric_normal = {5,6,1};
    tvec3<float> perturbed_normal = {4,5.5f,2};
    tvec3<float> eyeline = {-1,0.002f,-1.0345f};
    std::cout << "faceforward_nochange:" << faceforward(perturbed_normal, eyeline, geometric_normal) << std::endl;

    eyeline = (tvec3<float>){1,0.002f,-1.0345f};
    std::cout << "faceforward_flip:" << faceforward(perturbed_normal, eyeline, geometric_normal) << std::endl;
}

