#include <glm/glm.hpp>
#include <iostream>

using namespace glm;

std::ostream& operator<<(std::ostream& os, glm::tvec2<float>& v) {
    os << "<" << v.x << "," << v.y << ">";
    return os;
}
std::ostream& operator<<(std::ostream& os, glm::tvec2<float>&& v) {
    os << "<" << v.x << "," << v.y << ">";
    return os;
}

float length_squared(glm::tvec2<float> v) {
    return glm::length(v) * glm::length(v);
}

tvec2<float> project(glm::tvec2<float> u, glm::tvec2<float> v) {
    return normalize(v) * dot(u, normalize(v));
}

int main() {
    tvec2<float> v1 = {5.f,6.f};
    tvec2<float> v2 = {0.f,-1.f};
    std::cout << "refract:" << refract(v1,normalize(v2),1.f) << std::endl;
    std::cout << "refract:" << refract(v1,normalize(v2),1.f/1.33f) << std::endl;
}
