#include <glm/glm.hpp>
#include <iostream>
#define BENCH_N 1000000000
#include "../bench.h"

using namespace glm;


int main(int argc, char* argv[]) {
    tvec2<volatile float> v1(1,2);
    tvec2<volatile float> v2(20.5f, 30.2f);

    {
        BENCH(
            for (int i = 0; i < n; i ++) {
                volatile float res = dot(v1, v2);
                asm volatile ("":::"memory");
            },
            dot_b
        );
        std::cout << "dot: " << dot_b << std::endl;
    }

    {
        BENCH(
            for (int i = 0; i < n; i ++) {
                volatile vec2 res = v1 + v2;
                asm volatile ("":::"memory");
            },
            add_b
        );
        std::cout << "vector addition: " << add_b << std::endl;
    }

    {
        BENCH(
            for (int i = 0; i < n; i ++) {
                volatile vec2 res = normalize((tvec2<float>)v1);
                asm volatile ("":::"memory");
            },
            normalize_b
        );
        std::cout << "normalize: " << normalize_b << std::endl;
    }

    {
        BENCH(
            for (int i = 0; i < n; i ++) {
                volatile vec2 res = reflect((vec2)v1, (vec2)v2);
                asm volatile ("":::"memory");
            },
            reflect_b
        );
        std::cout << "reflect: " << reflect_b << std::endl;
    }
}
