//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// FunctionDecl.cc --
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Mar  7 07:54:58 2017
// Update Count     : 68
//

#include <cassert>

#include "Declaration.h"
#include "Statement.h"
#include "Type.h"
#include "Attribute.h"
#include "Common/utility.h"
#include "InitTweak/InitTweak.h"
#include "CodeGen/FixMain.h"

extern bool translation_unit_nomain;

FunctionDecl::FunctionDecl( const std::string &name, DeclarationNode::StorageClasses scs, LinkageSpec::Spec linkage, FunctionType *type, CompoundStmt *statements, std::list< Attribute * > attributes, DeclarationNode::FuncSpecifiers fs )
	: Parent( name, scs, linkage, attributes, fs ), type( type ), statements( statements ) {
	// hack forcing the function "main" to have Cforall linkage to replace main even if it is inside an extern
	if ( name == "main" ) {
		set_linkage( CodeGen::FixMain::mainLinkage() );
	} // if
}

FunctionDecl::FunctionDecl( const FunctionDecl &other )
		: Parent( other ), type( maybeClone( other.type ) ), statements( maybeClone( other.statements ) ) {
}

FunctionDecl::~FunctionDecl() {
	delete type;
	delete statements;
}

Type * FunctionDecl::get_type() const {
	return type;
}

void FunctionDecl::set_type( Type *t ) {
	type = dynamic_cast< FunctionType* >( t );
	assert( type );
}

void FunctionDecl::print( std::ostream &os, int indent ) const {
	using std::endl;
	using std::string;

	if ( get_name() != "" ) {
		os << get_name() << ": ";
	} // if
	if ( get_linkage() != LinkageSpec::Cforall ) {
		os << LinkageSpec::linkageName( get_linkage() ) << " ";
	} // if

	printAll( get_attributes(), os, indent );

	DeclarationNode::print_StorageClass( os, get_storageClasses() );
	DeclarationNode::print_FuncSpec( os, get_funcSpec() );

	if ( get_type() ) {
		get_type()->print( os, indent );
	} else {
		os << "untyped entity ";
	} // if

	if ( statements ) {
		os << string( indent + 2, ' ' ) << "with body " << endl;
		os << string( indent + 4, ' ' );
		statements->print( os, indent + 4 );
	} // if
}

void FunctionDecl::printShort( std::ostream &os, int indent ) const {
	using std::endl;
	using std::string;

	if ( get_name() != "" ) {
		os << get_name() << ": ";
	} // if

	// xxx - should printShort print attributes?

	DeclarationNode::print_StorageClass( os, get_storageClasses() );
	DeclarationNode::print_FuncSpec( os, get_funcSpec() );

	if ( get_type() ) {
		get_type()->print( os, indent );
	} else {
		os << "untyped entity ";
	} // if
}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
